/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/mongo/EventStreamSchemaInitializer;", "", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "enableRequestIdUniqueIndex", "", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;Z)V", "initAll", "", "initSchema", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "Companion", "wow-mongo"})
public final class EventStreamSchemaInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    private final boolean enableRequestIdUniqueIndex;
    private static final Logger log = LoggerFactory.getLogger(EventStreamSchemaInitializer.class);

    public EventStreamSchemaInitializer(@NotNull MongoDatabase database, boolean enableRequestIdUniqueIndex) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.enableRequestIdUniqueIndex = enableRequestIdUniqueIndex;
    }

    public /* synthetic */ EventStreamSchemaInitializer(MongoDatabase mongoDatabase, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(mongoDatabase, bl);
    }

    public final void initAll() {
        MetadataSearcher.INSTANCE.getNamedAggregateType().forEach((arg_0, arg_1) -> EventStreamSchemaInitializer.initAll$lambda$0((Function2)new Function2<MaterializedNamedAggregate, Class<?>, Unit>(this){
            final /* synthetic */ EventStreamSchemaInitializer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MaterializedNamedAggregate namedAggregate, @NotNull Class<?> clazz) {
                Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
                Intrinsics.checkNotNullParameter(clazz, (String)"<anonymous parameter 1>");
                this.this$0.initSchema((NamedAggregate)namedAggregate);
            }
        }, arg_0, arg_1));
    }

    public final void initSchema(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String collectionName = AggregateSchemaInitializer.INSTANCE.asEventStreamCollectionName(namedAggregate);
        if (log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{namedAggregate, this.database.getName(), collectionName};
            log.info("Init NamedAggregate Schema [{}] to Database:[{}] CollectionName [{}]", objectArray);
        }
        if (!AggregateSchemaInitializer.INSTANCE.ensureCollection(this.database, collectionName)) {
            return;
        }
        MongoCollection mongoCollection = this.database.getCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"database.getCollection(collectionName)");
        MongoCollection eventStreamCollection = mongoCollection;
        AggregateSchemaInitializer.INSTANCE.createAggregateIdIndex((MongoCollection<Document>)eventStreamCollection);
        AggregateSchemaInitializer.INSTANCE.createAggregateIdAndVersionUniqueIndex((MongoCollection<Document>)eventStreamCollection);
        if (this.enableRequestIdUniqueIndex) {
            AggregateSchemaInitializer.INSTANCE.createRequestIdUniqueIndex((MongoCollection<Document>)eventStreamCollection);
        } else {
            AggregateSchemaInitializer.INSTANCE.createAggregateIdAndRequestIdUniqueIndex((MongoCollection<Document>)eventStreamCollection);
        }
        AggregateSchemaInitializer.INSTANCE.createTenantIdIndex((MongoCollection<Document>)eventStreamCollection);
    }

    private static final void initAll$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/mongo/EventStreamSchemaInitializer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

