/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.MergeOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.AbstractEventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/ahoo/wow/mongo/MongoEventStore;", "Lme/ahoo/wow/eventsourcing/AbstractEventStore;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "<init>", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "appendStream", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "loadStream", "Lreactor/core/publisher/Flux;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "headVersion", "", "tailVersion", "tailCursorId", "", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "archiveAggregateId", "scanAggregateId", "cursorId", "limit", "findAggregateId", "Companion", "wow-mongo"})
@SourceDebugExtension(value={"SMAP\nMongoEventStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoEventStore.kt\nme/ahoo/wow/mongo/MongoEventStore\n+ 2 JsonSerializer.kt\nme/ahoo/wow/serialization/JsonSerializerKt\n*L\n1#1,185:1\n69#2:186\n*S KotlinDebug\n*F\n+ 1 MongoEventStore.kt\nme/ahoo/wow/mongo/MongoEventStore\n*L\n105#1:186\n*E\n"})
public final class MongoEventStore
extends AbstractEventStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private static final String SIZE_FIELD = "size";
    @NotNull
    private static final MergeOptions DEFAULT_MERGE_OPTIONS;

    public MongoEventStore(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    protected Mono<Void> appendStream(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName((NamedAggregate)eventStream);
        String eventStreamJson = JsonSerializerKt.toJsonString((Object)eventStream);
        Document document = Document.parse((String)eventStreamJson);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = Documents.INSTANCE.replaceIdToPrimaryKey(document).append(SIZE_FIELD, (Object)eventStream.getSize());
        Publisher publisher = this.database.getCollection(eventStreamCollectionName).insertOne((Object)document2);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"insertOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).doOnNext(arg_0 -> MongoEventStore.appendStream$lambda$1(MongoEventStore::appendStream$lambda$0, arg_0)).onErrorMap(MongoWriteException.class, arg_0 -> MongoEventStore.appendStream$lambda$3(arg_0 -> MongoEventStore.appendStream$lambda$2(eventStream, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    protected Flux<DomainEventStream> loadStream(@NotNull AggregateId aggregateId, int headVersion, int tailVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName((NamedAggregate)aggregateId);
        int limit = tailVersion - headVersion + 1;
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"aggregateId", (Object)aggregateId.getId()), Filters.gte((String)"version", (Object)headVersion), Filters.lte((String)"version", (Object)tailVersion)};
        FindPublisher findPublisher = this.database.getCollection(eventStreamCollectionName).find(Filters.and((Bson[])bsonArray)).limit(limit).batchSize(limit);
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"batchSize(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoEventStore.loadStream$lambda$6(arg_0 -> MongoEventStore.loadStream$lambda$5(aggregateId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Mono<String> tailCursorId(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String aggregateIdCollectionName = AggregateSchemaInitializer.INSTANCE.toAggregateIdCollectionName(namedAggregate);
        String[] stringArray = new String[]{"_id"};
        FindPublisher findPublisher = this.database.getCollection(aggregateIdCollectionName).find().sort(Sorts.descending((String[])stringArray));
        stringArray = new String[]{"_id"};
        Publisher publisher = findPublisher.projection(Projections.include((String[])stringArray)).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoEventStore.tailCursorId$lambda$8(MongoEventStore::tailCursorId$lambda$7, arg_0)).switchIfEmpty(Mono.just((Object)"(0)"));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"switchIfEmpty(...)");
        return mono;
    }

    @NotNull
    public Mono<Void> archiveAggregateId(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Mono mono = this.tailCursorId(namedAggregate).flatMap(arg_0 -> MongoEventStore.archiveAggregateId$lambda$10(arg_0 -> MongoEventStore.archiveAggregateId$lambda$9(this, namedAggregate, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @NotNull
    public Mono<Void> archiveAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String tailCursorId) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)tailCursorId, (String)"tailCursorId");
        String aggregateIdCollectionName = AggregateSchemaInitializer.INSTANCE.toAggregateIdCollectionName(namedAggregate);
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName(namedAggregate);
        Object[] objectArray = new Bson[5];
        objectArray[0] = Aggregates.match((Bson)Filters.gt((String)"aggregateId", (Object)tailCursorId));
        Object[] objectArray2 = new Bson[2];
        objectArray2[0] = Projections.excludeId();
        String[] stringArray = new String[]{"aggregateId", "tenantId"};
        objectArray2[1] = Projections.include((String[])stringArray);
        objectArray[1] = Aggregates.project((Bson)Projections.fields((Bson[])objectArray2));
        objectArray2 = new BsonField[]{new BsonField("tenantId", (Bson)new Document("$first", (Object)"$tenantId"))};
        objectArray[2] = Aggregates.group((Object)"$aggregateId", (BsonField[])objectArray2);
        objectArray2 = new String[]{"_id"};
        objectArray[3] = Aggregates.sort((Bson)Sorts.ascending((String[])objectArray2));
        objectArray[4] = Aggregates.merge((String)aggregateIdCollectionName, (MergeOptions)DEFAULT_MERGE_OPTIONS);
        Publisher publisher = this.database.getCollection(eventStreamCollectionName).aggregate(CollectionsKt.listOf((Object[])objectArray)).toCollection();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"toCollection(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    @NotNull
    public Flux<AggregateId> scanAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String cursorId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)cursorId, (String)"cursorId");
        Flux flux = this.archiveAggregateId(namedAggregate).thenMany((Publisher)this.findAggregateId(namedAggregate, cursorId, limit));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"thenMany(...)");
        return flux;
    }

    private final Flux<AggregateId> findAggregateId(NamedAggregate namedAggregate, String cursorId, int limit) {
        String aggregateIdCollectionName = AggregateSchemaInitializer.INSTANCE.toAggregateIdCollectionName(namedAggregate);
        String[] stringArray = new String[]{"_id"};
        FindPublisher findPublisher = this.database.getCollection(aggregateIdCollectionName).find(Filters.gt((String)"_id", (Object)cursorId)).sort(Sorts.ascending((String[])stringArray)).limit(limit).batchSize(limit);
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"batchSize(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoEventStore.findAggregateId$lambda$12(arg_0 -> MongoEventStore.findAggregateId$lambda$11(namedAggregate, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    private static final Unit appendStream$lambda$0(InsertOneResult it) {
        if (!it.wasAcknowledged()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return Unit.INSTANCE;
    }

    private static final void appendStream$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Throwable appendStream$lambda$2(DomainEventStream $eventStream, MongoWriteException it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        if (ErrorCategory.fromErrorCode((int)it.getCode()) != ErrorCategory.DUPLICATE_KEY) {
            return (Throwable)it;
        }
        String string = it.getMessage();
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"aggregateId_1_version_1", (boolean)false, (int)2, null)) {
            return (Throwable)new EventVersionConflictException($eventStream, null, (Throwable)it, 2, null);
        }
        String string2 = it.getMessage();
        Intrinsics.checkNotNull((Object)string2);
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"requestId_1", (boolean)false, (int)2, null)) {
            return (Throwable)new DuplicateRequestIdException($eventStream.getAggregateId(), $eventStream.getRequestId(), null, (Throwable)it, 4, null);
        }
        return (Throwable)it;
    }

    private static final Throwable appendStream$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final DomainEventStream loadStream$lambda$5(AggregateId $aggregateId, Document it) {
        Intrinsics.checkNotNullParameter((Object)$aggregateId, (String)"$aggregateId");
        Intrinsics.checkNotNull((Object)it);
        String string = Documents.INSTANCE.replacePrimaryKeyToId(it).toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String $this$toObject$iv = string;
        boolean $i$f$toObject = false;
        DomainEventStream domainEventStream = (DomainEventStream)JsonSerializerKt.toObject((String)$this$toObject$iv, DomainEventStream.class);
        if (!Intrinsics.areEqual((Object)domainEventStream.getAggregateId(), (Object)$aggregateId)) {
            boolean bl = false;
            String string2 = "aggregateId is not match! aggregateId: " + $aggregateId + ", domainEventStream: " + domainEventStream.getAggregateId();
            throw new IllegalArgumentException(string2.toString());
        }
        return domainEventStream;
    }

    private static final DomainEventStream loadStream$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    private static final String tailCursorId$lambda$7(Document it) {
        return it.getString((Object)"_id");
    }

    private static final String tailCursorId$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Mono archiveAggregateId$lambda$9(MongoEventStore this$0, NamedAggregate $namedAggregate, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$namedAggregate, (String)"$namedAggregate");
        Intrinsics.checkNotNull((Object)it);
        return this$0.archiveAggregateId($namedAggregate, it);
    }

    private static final Mono archiveAggregateId$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final AggregateId findAggregateId$lambda$11(NamedAggregate $namedAggregate, Document it) {
        Intrinsics.checkNotNullParameter((Object)$namedAggregate, (String)"$namedAggregate");
        String string = it.getString((Object)"_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = it.getString((Object)"tenantId");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return (AggregateId)DefaultAggregateIdKt.aggregateId((NamedAggregate)$namedAggregate, (String)string, (String)string2);
    }

    private static final AggregateId findAggregateId$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateId)$tmp0.invoke(p0);
    }

    static {
        MergeOptions mergeOptions = new MergeOptions().uniqueIdentifier("_id").whenMatched(MergeOptions.WhenMatched.KEEP_EXISTING).whenNotMatched(MergeOptions.WhenNotMatched.INSERT);
        Intrinsics.checkNotNullExpressionValue((Object)mergeOptions, (String)"whenNotMatched(...)");
        DEFAULT_MERGE_OPTIONS = mergeOptions;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/mongo/MongoEventStore$Companion;", "", "<init>", "()V", "SIZE_FIELD", "", "DEFAULT_MERGE_OPTIONS", "Lcom/mongodb/client/model/MergeOptions;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

