/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query.event;

import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.DynamicDocument;
import me.ahoo.wow.api.query.IListQuery;
import me.ahoo.wow.api.query.Queryable;
import me.ahoo.wow.api.query.SimpleDynamicDocument;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.mongo.query.MongoCollectionsKt;
import me.ahoo.wow.mongo.query.MongoConditionConverter;
import me.ahoo.wow.query.converter.ConditionConverter;
import me.ahoo.wow.query.event.EventStreamQueryService;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.kotlin.core.publisher.FluxExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/mongo/query/event/MongoEventStreamQueryService;", "Lme/ahoo/wow/query/event/EventStreamQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "converter", "Lme/ahoo/wow/query/converter/ConditionConverter;", "Lorg/bson/conversions/Bson;", "<init>", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lcom/mongodb/reactivestreams/client/MongoCollection;Lme/ahoo/wow/query/converter/ConditionConverter;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "findDocument", "Lcom/mongodb/reactivestreams/client/FindPublisher;", "queryable", "Lme/ahoo/wow/api/query/Queryable;", "list", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/event/DomainEventStream;", "listQuery", "Lme/ahoo/wow/api/query/IListQuery;", "dynamicList", "Lme/ahoo/wow/api/query/DynamicDocument;", "wow-mongo"})
@SourceDebugExtension(value={"SMAP\nMongoEventStreamQueryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoEventStreamQueryService.kt\nme/ahoo/wow/mongo/query/event/MongoEventStreamQueryService\n+ 2 JsonSerializer.kt\nme/ahoo/wow/serialization/JsonSerializerKt\n*L\n1#1,62:1\n69#2:63\n*S KotlinDebug\n*F\n+ 1 MongoEventStreamQueryService.kt\nme/ahoo/wow/mongo/query/event/MongoEventStreamQueryService\n*L\n49#1:63\n*E\n"})
public final class MongoEventStreamQueryService
implements EventStreamQueryService {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final MongoCollection<Document> collection;
    @NotNull
    private final ConditionConverter<Bson> converter;

    public MongoEventStreamQueryService(@NotNull NamedAggregate namedAggregate, @NotNull MongoCollection<Document> collection, @NotNull ConditionConverter<Bson> converter) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.namedAggregate = namedAggregate;
        this.collection = collection;
        this.converter = converter;
    }

    public /* synthetic */ MongoEventStreamQueryService(NamedAggregate namedAggregate, MongoCollection mongoCollection, ConditionConverter conditionConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            conditionConverter = MongoConditionConverter.INSTANCE;
        }
        this(namedAggregate, (MongoCollection<Document>)mongoCollection, (ConditionConverter<Bson>)conditionConverter);
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    private final FindPublisher<Document> findDocument(Queryable<?> queryable) {
        return MongoCollectionsKt.findDocument(this.collection, this.converter, queryable);
    }

    @NotNull
    public Flux<DomainEventStream> list(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        FindPublisher findPublisher = this.findDocument((Queryable)listQuery).limit(listQuery.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoEventStreamQueryService.list$lambda$1(MongoEventStreamQueryService::list$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flux<DynamicDocument> dynamicList(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        FindPublisher findPublisher = this.findDocument((Queryable)listQuery).limit(listQuery.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoEventStreamQueryService.dynamicList$lambda$3(MongoEventStreamQueryService::dynamicList$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    private static final DomainEventStream list$lambda$0(Document it) {
        Intrinsics.checkNotNull((Object)it);
        String string = Documents.INSTANCE.replacePrimaryKeyToId(it).toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String $this$toObject$iv = string;
        boolean $i$f$toObject = false;
        return (DomainEventStream)JsonSerializerKt.toObject((String)$this$toObject$iv, DomainEventStream.class);
    }

    private static final DomainEventStream list$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    private static final DynamicDocument dynamicList$lambda$2(Document it) {
        Intrinsics.checkNotNull((Object)it);
        return (DynamicDocument)SimpleDynamicDocument.Companion.toDynamicDocument((Map)Documents.INSTANCE.replacePrimaryKeyToId(it));
    }

    private static final DynamicDocument dynamicList$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DynamicDocument)$tmp0.invoke(p0);
    }
}

