/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.mongodb.client.model.Filters;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.query.converter.AbstractConditionConverter;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J'\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010(\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010-\u001a\u00020\u0002*\u00020\u0007\u00a8\u0006."}, d2={"Lme/ahoo/wow/mongo/query/MongoConditionConverter;", "Lme/ahoo/wow/query/converter/AbstractConditionConverter;", "Lorg/bson/conversions/Bson;", "<init>", "()V", "and", "condition", "Lme/ahoo/wow/api/query/Condition;", "or", "nor", "id", "ids", "tenantId", "all", "eq", "ne", "gt", "lt", "gte", "lte", "regex", "field", "", "value", "ignoreCase", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/bson/conversions/Bson;", "contains", "startsWith", "endsWith", "isIn", "notIn", "between", "allIn", "elemMatch", "isNull", "notNull", "isTrue", "isFalse", "deleted", "timeRange", "from", "Ljava/time/LocalDateTime;", "to", "raw", "toMongoFilter", "wow-mongo"})
@SourceDebugExtension(value={"SMAP\nMongoConditionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoConditionConverter.kt\nme/ahoo/wow/mongo/query/MongoConditionConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1557#2:191\n1628#2,3:192\n1557#2:195\n1628#2,3:196\n1557#2:199\n1628#2,3:200\n1#3:203\n*S KotlinDebug\n*F\n+ 1 MongoConditionConverter.kt\nme/ahoo/wow/mongo/query/MongoConditionConverter\n*L\n33#1:191\n33#1:192,3\n40#1:195\n40#1:196,3\n47#1:199\n47#1:200,3\n*E\n"})
public final class MongoConditionConverter
extends AbstractConditionConverter<Bson> {
    @NotNull
    public static final MongoConditionConverter INSTANCE = new MongoConditionConverter();

    private MongoConditionConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson and(@NotNull Condition condition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (!(!((Collection)condition.getChildren()).isEmpty())) {
            boolean $i$a$-require-MongoConditionConverter$and$22 = false;
            String $i$a$-require-MongoConditionConverter$and$22 = "AND operator children cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$and$22.toString());
        }
        Iterable $this$map$iv = condition.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Condition condition2 = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Bson)INSTANCE.convert((Condition)it));
        }
        Bson bson = Filters.and((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson or(@NotNull Condition condition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (!(!((Collection)condition.getChildren()).isEmpty())) {
            boolean $i$a$-require-MongoConditionConverter$or$22 = false;
            String $i$a$-require-MongoConditionConverter$or$22 = "OR operator children cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$or$22.toString());
        }
        Iterable $this$map$iv = condition.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Condition condition2 = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Bson)INSTANCE.convert((Condition)it));
        }
        Bson bson = Filters.or((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"or(...)");
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson nor(@NotNull Condition condition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (!(!((Collection)condition.getChildren()).isEmpty())) {
            boolean $i$a$-require-MongoConditionConverter$nor$22 = false;
            String $i$a$-require-MongoConditionConverter$nor$22 = "NOR operator children cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$nor$22.toString());
        }
        Iterable $this$map$iv = condition.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Condition condition2 = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Bson)INSTANCE.convert((Condition)it));
        }
        Bson bson = Filters.nor((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"nor(...)");
        return bson;
    }

    @NotNull
    public Bson id(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson ids(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.in((String)"_id", (Iterable)((Iterable)condition.valueAs()));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"in(...)");
        return bson;
    }

    @NotNull
    public Bson tenantId(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)"tenantId", (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson all(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.empty();
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"empty(...)");
        return bson;
    }

    @NotNull
    public Bson eq(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson ne(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.ne((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"ne(...)");
        return bson;
    }

    @NotNull
    public Bson gt(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.gt((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gt(...)");
        return bson;
    }

    @NotNull
    public Bson lt(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.lt((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"lt(...)");
        return bson;
    }

    @NotNull
    public Bson gte(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.gte((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gte(...)");
        return bson;
    }

    @NotNull
    public Bson lte(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.lte((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"lte(...)");
        return bson;
    }

    private final Bson regex(String field, String value, Boolean ignoreCase) {
        Bson bson;
        if (Intrinsics.areEqual((Object)ignoreCase, (Object)true)) {
            Bson bson2 = Filters.regex((String)field, (String)value, (String)"i");
            Intrinsics.checkNotNull((Object)bson2);
            bson = bson2;
        } else {
            Bson bson3 = Filters.regex((String)field, (String)value);
            Intrinsics.checkNotNull((Object)bson3);
            bson = bson3;
        }
        return bson;
    }

    @NotNull
    public Bson contains(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return this.regex(condition.getField(), (String)condition.valueAs(), condition.ignoreCase());
    }

    @NotNull
    public Bson startsWith(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return this.regex(condition.getField(), "^" + condition.valueAs(), condition.ignoreCase());
    }

    @NotNull
    public Bson endsWith(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return this.regex(condition.getField(), condition.valueAs() + "$", condition.ignoreCase());
    }

    @NotNull
    public Bson isIn(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.in((String)condition.getField(), (Iterable)((Iterable)condition.valueAs()));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"in(...)");
        return bson;
    }

    @NotNull
    public Bson notIn(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.nin((String)condition.getField(), (Iterable)((Iterable)condition.valueAs()));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"nin(...)");
        return bson;
    }

    @NotNull
    public Bson between(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Iterable valueIterable = (Iterable)condition.valueAs();
        Iterator ite = valueIterable.iterator();
        if (!ite.hasNext()) {
            boolean $i$a$-require-MongoConditionConverter$between$32 = false;
            String $i$a$-require-MongoConditionConverter$between$32 = "BETWEEN operator value must be a array with 2 elements.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$between$32.toString());
        }
        Object first = ite.next();
        if (!ite.hasNext()) {
            boolean bl = false;
            String string = "BETWEEN operator value must be a array with 2 elements.";
            throw new IllegalArgumentException(string.toString());
        }
        Object second = ite.next();
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), first), Filters.lte((String)condition.getField(), second)};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson allIn(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.all((String)condition.getField(), (Iterable)((Iterable)condition.valueAs()));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"all(...)");
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson elemMatch(@NotNull Condition condition) {
        void it;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Condition condition2 = (Condition)CollectionsKt.first((List)condition.getChildren());
        String string = condition.getField();
        boolean bl = false;
        Bson bson = Filters.elemMatch((String)string, (Bson)((Bson)INSTANCE.convert((Condition)it)));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"elemMatch(...)");
        return bson;
    }

    @NotNull
    public Bson isNull(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), null);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson notNull(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.ne((String)condition.getField(), null);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"ne(...)");
        return bson;
    }

    @NotNull
    public Bson isTrue(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson isFalse(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson deleted(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)"deleted", (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson timeRange(@NotNull String field, @NotNull LocalDateTime from, @NotNull LocalDateTime to) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Bson[] bsonArray = new Bson[]{Filters.gte((String)field, (Object)from.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)field, (Object)to.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson raw(@NotNull Condition condition) {
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = condition.getValue();
        if (object instanceof Bson) {
            bson = (Bson)condition.valueAs();
        } else if (object instanceof String) {
            Document document = Document.parse((String)((String)condition.valueAs()));
            Intrinsics.checkNotNull((Object)document);
            bson = (Bson)document;
        } else if (object instanceof Map) {
            bson = (Bson)new Document((Map)condition.valueAs());
        } else {
            String conditionValueJson = JsonSerializerKt.toJsonString((Object)condition.getValue());
            Document document = Document.parse((String)conditionValueJson);
            Intrinsics.checkNotNull((Object)document);
            bson = (Bson)document;
        }
        return bson;
    }

    @NotNull
    public final Bson toMongoFilter(@NotNull Condition $this$toMongoFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$toMongoFilter, (String)"<this>");
        return (Bson)this.convert($this$toMongoFilter);
    }
}

