/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query.event;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.query.event.MongoEventStreamQueryService;
import me.ahoo.wow.query.event.EventStreamQueryService;
import me.ahoo.wow.query.event.EventStreamQueryServiceFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/mongo/query/event/MongoEventStreamQueryServiceFactory;", "Lme/ahoo/wow/query/event/EventStreamQueryServiceFactory;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "<init>", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "queryServiceCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "Lme/ahoo/wow/query/event/EventStreamQueryService;", "create", "namedAggregate", "createQueryService", "wow-mongo"})
public final class MongoEventStreamQueryServiceFactory
implements EventStreamQueryServiceFactory {
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private final ConcurrentHashMap<NamedAggregate, EventStreamQueryService> queryServiceCache;

    public MongoEventStreamQueryServiceFactory(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.queryServiceCache = new ConcurrentHashMap();
    }

    @NotNull
    public EventStreamQueryService create(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        EventStreamQueryService eventStreamQueryService = this.queryServiceCache.computeIfAbsent((NamedAggregate)MaterializedNamedAggregateKt.materialize((NamedAggregate)namedAggregate), arg_0 -> MongoEventStreamQueryServiceFactory.create$lambda$1(arg_0 -> MongoEventStreamQueryServiceFactory.create$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)eventStreamQueryService, (String)"computeIfAbsent(...)");
        return eventStreamQueryService;
    }

    private final EventStreamQueryService createQueryService(NamedAggregate namedAggregate) {
        String collectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName(namedAggregate);
        MongoCollection mongoCollection = this.database.getCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection collection = mongoCollection;
        return new MongoEventStreamQueryService((NamedAggregate)MaterializedNamedAggregateKt.materialize((NamedAggregate)namedAggregate), collection, null, 4, null);
    }

    private static final EventStreamQueryService create$lambda$0(MongoEventStreamQueryServiceFactory this$0, NamedAggregate it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createQueryService(it);
    }

    private static final EventStreamQueryService create$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EventStreamQueryService)$tmp0.invoke(p0);
    }
}

