/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.MongoSnapshotRepository;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\u0006\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\f0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/mongo/MongoSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "getVersion", "Lreactor/core/publisher/Mono;", "", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "load", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "mapSnapshot", "document", "Lorg/bson/Document;", "save", "Ljava/lang/Void;", "snapshot", "Companion", "wow-mongo"})
public final class MongoSnapshotRepository
implements SnapshotRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private static final ReplaceOptions DEFAULT_REPLACE_OPTIONS;

    public MongoSnapshotRepository(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName((NamedAggregate)aggregateId);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).find(Filters.eq((String)"_id", (Object)aggregateId.getId())).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoSnapshotRepository.load$lambda$0((Function1)new Function1<Document, Snapshot<S>>(this, aggregateId){
            final /* synthetic */ MongoSnapshotRepository this$0;
            final /* synthetic */ AggregateId $aggregateId;
            {
                this.this$0 = $receiver;
                this.$aggregateId = $aggregateId;
                super(1);
            }

            public final Snapshot<S> invoke(Document it) {
                Intrinsics.checkNotNull((Object)it);
                return MongoSnapshotRepository.access$mapSnapshot(this.this$0, this.$aggregateId, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<Integer> getVersion(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName((NamedAggregate)aggregateId);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).find(Filters.eq((String)"_id", (Object)aggregateId.getId())).projection((Bson)new Document("version", (Object)1)).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoSnapshotRepository.getVersion$lambda$1(getVersion.1.INSTANCE, arg_0)).defaultIfEmpty((Object)0);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defaultIfEmpty(...)");
        return mono;
    }

    private final <S> Snapshot<S> mapSnapshot(AggregateId aggregateId, Document document) {
        Snapshot snapshot = DocumentsKt.toSnapshot(document);
        if (!Intrinsics.areEqual((Object)aggregateId, (Object)snapshot.getAggregateId())) {
            boolean bl = false;
            String string = "aggregateId: " + aggregateId + " != snapshot.aggregateId: " + snapshot.getAggregateId();
            throw new IllegalArgumentException(string.toString());
        }
        return snapshot;
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName((NamedAggregate)snapshot.getAggregateId());
        String snapshotJsonString = JsonSerializerKt.toJsonString(snapshot);
        Document document = Document.parse((String)snapshotJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = Documents.INSTANCE.replaceAggregateIdToPrimaryKey(document);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).replaceOne(Filters.eq((String)"_id", (Object)snapshot.getAggregateId().getId()), (Object)document2, DEFAULT_REPLACE_OPTIONS);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"replaceOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).doOnNext(arg_0 -> MongoSnapshotRepository.save$lambda$3(save.1.INSTANCE, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private static final Snapshot load$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Snapshot)$tmp0.invoke(p0);
    }

    private static final Integer getVersion$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final void save$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Snapshot access$mapSnapshot(MongoSnapshotRepository $this, AggregateId aggregateId, Document document) {
        return $this.mapSnapshot(aggregateId, document);
    }

    static {
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        DEFAULT_REPLACE_OPTIONS = replaceOptions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/ahoo/wow/mongo/MongoSnapshotRepository$Companion;", "", "()V", "DEFAULT_REPLACE_OPTIONS", "Lcom/mongodb/client/model/ReplaceOptions;", "getDEFAULT_REPLACE_OPTIONS", "()Lcom/mongodb/client/model/ReplaceOptions;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReplaceOptions getDEFAULT_REPLACE_OPTIONS() {
            return DEFAULT_REPLACE_OPTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

