/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.IListQuery;
import me.ahoo.wow.api.query.IPagedQuery;
import me.ahoo.wow.api.query.ISingleQuery;
import me.ahoo.wow.api.query.MaterializedSnapshot;
import me.ahoo.wow.api.query.PagedList;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.query.MongoConditionConverter;
import me.ahoo.wow.mongo.query.MongoFilterConverter;
import me.ahoo.wow.mongo.query.MongoSnapshotQueryService;
import me.ahoo.wow.query.ConditionConverter;
import me.ahoo.wow.query.SnapshotQueryService;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u001d0\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u00132\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/ahoo/wow/mongo/query/MongoSnapshotQueryService;", "S", "", "Lme/ahoo/wow/query/SnapshotQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "converter", "Lme/ahoo/wow/query/ConditionConverter;", "Lorg/bson/conversions/Bson;", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lcom/mongodb/reactivestreams/client/MongoCollection;Lme/ahoo/wow/query/ConditionConverter;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "snapshotType", "Lcom/fasterxml/jackson/databind/JavaType;", "kotlin.jvm.PlatformType", "count", "Lreactor/core/publisher/Mono;", "", "condition", "Lme/ahoo/wow/api/query/Condition;", "list", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/api/query/MaterializedSnapshot;", "listQuery", "Lme/ahoo/wow/api/query/IListQuery;", "paged", "Lme/ahoo/wow/api/query/PagedList;", "pagedQuery", "Lme/ahoo/wow/api/query/IPagedQuery;", "single", "singleQuery", "Lme/ahoo/wow/api/query/ISingleQuery;", "wow-mongo"})
public final class MongoSnapshotQueryService<S>
implements SnapshotQueryService<S> {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final MongoCollection<Document> collection;
    @NotNull
    private final ConditionConverter<Bson> converter;
    private final JavaType snapshotType;

    public MongoSnapshotQueryService(@NotNull NamedAggregate namedAggregate, @NotNull MongoCollection<Document> collection, @NotNull ConditionConverter<Bson> converter) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.namedAggregate = namedAggregate;
        this.collection = collection;
        this.converter = converter;
        Class[] classArray = new Class[]{AggregateMetadataParserKt.aggregateMetadata((Class)MetadataSearcherKt.requiredAggregateType((NamedAggregate)this.getNamedAggregate())).getState().getAggregateType()};
        this.snapshotType = TypeFactory.defaultInstance().constructParametricType(MaterializedSnapshot.class, classArray);
    }

    public /* synthetic */ MongoSnapshotQueryService(NamedAggregate namedAggregate, MongoCollection mongoCollection, ConditionConverter conditionConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            conditionConverter = MongoConditionConverter.INSTANCE;
        }
        this(namedAggregate, (MongoCollection<Document>)mongoCollection, (ConditionConverter<Bson>)conditionConverter);
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public Mono<MaterializedSnapshot<S>> single(@NotNull ISingleQuery singleQuery) {
        Intrinsics.checkNotNullParameter((Object)singleQuery, (String)"singleQuery");
        Bson filter = (Bson)this.converter.convert(singleQuery.getCondition());
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(singleQuery.getSort());
        Publisher publisher = this.collection.find(filter).sort(sort).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher);
        JavaType javaType = this.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        return DocumentsKt.toMaterializedSnapshot((Mono<Document>)mono, javaType);
    }

    @NotNull
    public Flux<MaterializedSnapshot<S>> list(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        Bson filter = (Bson)this.converter.convert(listQuery.getCondition());
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(listQuery.getSort());
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).limit(listQuery.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher));
        JavaType javaType = this.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        return DocumentsKt.toMaterializedSnapshot((Flux<Document>)flux, javaType);
    }

    @NotNull
    public Mono<PagedList<MaterializedSnapshot<S>>> paged(@NotNull IPagedQuery pagedQuery) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery, (String)"pagedQuery");
        Bson filter = (Bson)this.converter.convert(pagedQuery.getCondition());
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(pagedQuery.getSort());
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        Mono totalPublisher = MonoExtensionsKt.toMono((Publisher)publisher);
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).skip(pagedQuery.getPagination().offset()).limit(pagedQuery.getPagination().getSize());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher));
        JavaType javaType = this.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        Mono mono = DocumentsKt.toMaterializedSnapshot((Flux<Document>)flux, javaType).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        Mono listPublisher = mono;
        Mono mono2 = Mono.zip((Mono)totalPublisher, (Mono)listPublisher).map(arg_0 -> MongoSnapshotQueryService.paged$lambda$0(paged.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"map(...)");
        return mono2;
    }

    @NotNull
    public Mono<Long> count(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson filter = (Bson)this.converter.convert(condition);
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    private static final PagedList paged$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PagedList)$tmp0.invoke(p0);
    }
}

