/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.prepare;

import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.infra.accessor.function.reactive.BlockingMonoFunctionAccessorKt;
import me.ahoo.wow.infra.prepare.PrepareKey;
import me.ahoo.wow.infra.prepare.PreparedValue;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.prepare.MongoPrepareKey;
import me.ahoo.wow.mongo.prepare.PrepareRecords;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001eB#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016J1\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00028\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00a2\u0006\u0002\u0010\u001bJ$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/ahoo/wow/mongo/prepare/MongoPrepareKey;", "V", "", "Lme/ahoo/wow/infra/prepare/PrepareKey;", "name", "", "valueType", "Ljava/lang/Class;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "(Ljava/lang/String;Ljava/lang/Class;Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "getName", "()Ljava/lang/String;", "prepareCollection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "prepareCollectionName", "getValue", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/infra/prepare/PreparedValue;", "key", "prepare", "", "value", "reprepare", "oldValue", "newValue", "(Ljava/lang/String;Ljava/lang/Object;Lme/ahoo/wow/infra/prepare/PreparedValue;)Lreactor/core/publisher/Mono;", "rollback", "(Ljava/lang/String;Ljava/lang/Object;)Lreactor/core/publisher/Mono;", "Companion", "wow-mongo"})
public final class MongoPrepareKey<V>
implements PrepareKey<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Class<V> valueType;
    @NotNull
    private final String prepareCollectionName;
    @NotNull
    private final MongoCollection<Document> prepareCollection;
    @NotNull
    private static final ReplaceOptions DEFAULT_REPLACE_OPTIONS;

    public MongoPrepareKey(@NotNull String name, @NotNull Class<V> valueType, @NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.name = name;
        this.valueType = valueType;
        this.prepareCollectionName = "prepare_" + this.getName();
        MongoCollection mongoCollection = database.getCollection(this.prepareCollectionName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        this.prepareCollection = mongoCollection;
        if (AggregateSchemaInitializer.INSTANCE.ensureCollection(database, this.prepareCollectionName)) {
            String[] stringArray = new String[]{"ttlAt"};
            Publisher publisher = this.prepareCollection.createIndex(Indexes.ascending((String[])stringArray), new IndexOptions().expireAfter(Long.valueOf(0L), TimeUnit.SECONDS));
            Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
            BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Mono<Boolean> prepare(@NotNull String key, @NotNull PreparedValue<V> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Document document = PrepareRecords.INSTANCE.toDocument(value);
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"_id", (Object)key), Filters.lt((String)"ttlAt", (Object)new Date())};
        Publisher publisher = this.prepareCollection.replaceOne(Filters.and((Bson[])bsonArray), (Object)document, DEFAULT_REPLACE_OPTIONS);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"replaceOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoPrepareKey.prepare$lambda$0(prepare.1.INSTANCE, arg_0)).onErrorResume(MongoWriteException.class, arg_0 -> MongoPrepareKey.prepare$lambda$1(prepare.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorResume(...)");
        return mono;
    }

    @NotNull
    public Mono<PreparedValue<V>> getValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Publisher publisher = this.prepareCollection.find(Filters.eq((String)"_id", (Object)key)).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoPrepareKey.getValue$lambda$2((Function1)new Function1<Document, PreparedValue<V>>(this){
            final /* synthetic */ MongoPrepareKey<V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final PreparedValue<V> invoke(Document it) {
                Intrinsics.checkNotNull((Object)it);
                return PrepareRecords.INSTANCE.toPreparedValue(it, MongoPrepareKey.access$getValueType$p(this.this$0));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<Boolean> rollback(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"_id", (Object)key), Filters.gt((String)"ttlAt", (Object)new Date())};
        Publisher publisher = this.prepareCollection.deleteOne(Filters.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"deleteOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoPrepareKey.rollback$lambda$3(rollback.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<Boolean> rollback(@NotNull String key, @NotNull V value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Document document = PrepareRecords.INSTANCE.toDocument(PreparedValue.Companion.toForever(value));
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"_id", (Object)key), Filters.eq((String)"value", (Object)document.get((Object)"value"))};
        Publisher publisher = this.prepareCollection.deleteOne(Filters.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"deleteOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoPrepareKey.rollback$lambda$4(rollback.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<Boolean> reprepare(@NotNull String key, @NotNull PreparedValue<V> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Document valueDocument = PrepareRecords.INSTANCE.toDocument(value);
        Bson[] bsonArray = new Bson[]{Updates.set((String)"value", (Object)valueDocument.get((Object)"value")), Updates.set((String)"ttlAt", (Object)valueDocument.get((Object)"ttlAt"))};
        Publisher publisher = this.prepareCollection.updateOne(Filters.eq((String)"_id", (Object)key), Updates.combine((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"updateOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoPrepareKey.reprepare$lambda$5(reprepare.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<Boolean> reprepare(@NotNull String key, @NotNull V oldValue, @NotNull PreparedValue<V> newValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        Document oldValueDocument = PrepareRecords.INSTANCE.toDocument(PreparedValue.Companion.toForever(oldValue));
        Document newValueDocument = PrepareRecords.INSTANCE.toDocument(newValue);
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"_id", (Object)key), Filters.eq((String)"value", (Object)oldValueDocument.get((Object)"value"))};
        Bson bson = Filters.and((Bson[])bsonArray);
        bsonArray = new Bson[]{Updates.set((String)"value", (Object)newValueDocument.get((Object)"value")), Updates.set((String)"ttlAt", (Object)newValueDocument.get((Object)"ttlAt"))};
        Publisher publisher = this.prepareCollection.updateOne(bson, Updates.combine((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"updateOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoPrepareKey.reprepare$lambda$6(reprepare.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final Boolean prepare$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Mono prepare$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final PreparedValue getValue$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PreparedValue)$tmp0.invoke(p0);
    }

    private static final Boolean rollback$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean rollback$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean reprepare$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean reprepare$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Class access$getValueType$p(MongoPrepareKey $this) {
        return $this.valueType;
    }

    static {
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true).bypassDocumentValidation(Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"bypassDocumentValidation(...)");
        DEFAULT_REPLACE_OPTIONS = replaceOptions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/ahoo/wow/mongo/prepare/MongoPrepareKey$Companion;", "", "()V", "DEFAULT_REPLACE_OPTIONS", "Lcom/mongodb/client/model/ReplaceOptions;", "getDEFAULT_REPLACE_OPTIONS", "()Lcom/mongodb/client/model/ReplaceOptions;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReplaceOptions getDEFAULT_REPLACE_OPTIONS() {
            return DEFAULT_REPLACE_OPTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

