/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.mongodb.client.model.Filters;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.query.converter.ConditionConverter;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0002H\u0016J\n\u0010,\u001a\u00020\u0002*\u00020\u0007\u00a8\u0006-"}, d2={"Lme/ahoo/wow/mongo/query/MongoConditionConverter;", "Lme/ahoo/wow/query/converter/ConditionConverter;", "Lorg/bson/conversions/Bson;", "<init>", "()V", "and", "condition", "Lme/ahoo/wow/api/query/Condition;", "or", "id", "ids", "tenantId", "all", "eq", "ne", "gt", "lt", "gte", "lte", "contains", "isIn", "notIn", "between", "allIn", "startsWith", "endsWith", "elemMatch", "isNull", "notNull", "isTrue", "isFalse", "deleted", "today", "tomorrow", "thisWeek", "nextWeek", "lastWeek", "thisMonth", "lastMonth", "recentDays", "raw", "not", "", "target", "toMongoFilter", "wow-mongo"})
@SourceDebugExtension(value={"SMAP\nMongoConditionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoConditionConverter.kt\nme/ahoo/wow/mongo/query/MongoConditionConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1557#2:258\n1628#2,3:259\n1557#2:262\n1628#2,3:263\n1#3:266\n*S KotlinDebug\n*F\n+ 1 MongoConditionConverter.kt\nme/ahoo/wow/mongo/query/MongoConditionConverter\n*L\n36#1:258\n36#1:259,3\n43#1:262\n43#1:263,3\n*E\n"})
public final class MongoConditionConverter
implements ConditionConverter<Bson> {
    @NotNull
    public static final MongoConditionConverter INSTANCE = new MongoConditionConverter();

    private MongoConditionConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson and(@NotNull Condition condition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (!(!((Collection)condition.getChildren()).isEmpty())) {
            boolean $i$a$-require-MongoConditionConverter$and$22 = false;
            String $i$a$-require-MongoConditionConverter$and$22 = "AND operator children cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$and$22.toString());
        }
        Iterable $this$map$iv = condition.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Condition condition2 = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Bson)INSTANCE.convert((Condition)it));
        }
        Bson bson = Filters.and((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson or(@NotNull Condition condition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (!(!((Collection)condition.getChildren()).isEmpty())) {
            boolean $i$a$-require-MongoConditionConverter$or$22 = false;
            String $i$a$-require-MongoConditionConverter$or$22 = "OR operator children cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$or$22.toString());
        }
        Iterable $this$map$iv = condition.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Condition condition2 = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Bson)INSTANCE.convert((Condition)it));
        }
        Bson bson = Filters.or((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"or(...)");
        return bson;
    }

    @NotNull
    public Bson id(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson ids(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Bson bson = Filters.in((String)"_id", (Iterable)((List)object));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"in(...)");
        return bson;
    }

    @NotNull
    public Bson tenantId(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)"tenantId", (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson all(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.empty();
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"empty(...)");
        return bson;
    }

    @NotNull
    public Bson eq(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson ne(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.ne((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"ne(...)");
        return bson;
    }

    @NotNull
    public Bson gt(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.gt((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gt(...)");
        return bson;
    }

    @NotNull
    public Bson lt(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.lt((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"lt(...)");
        return bson;
    }

    @NotNull
    public Bson gte(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.gte((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gte(...)");
        return bson;
    }

    @NotNull
    public Bson lte(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.lte((String)condition.getField(), (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"lte(...)");
        return bson;
    }

    @NotNull
    public Bson contains(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        String string = condition.getField();
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        Bson bson = Filters.regex((String)string, (String)((String)object));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"regex(...)");
        return bson;
    }

    @NotNull
    public Bson isIn(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        String string = condition.getField();
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Bson bson = Filters.in((String)string, (Iterable)((List)object));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"in(...)");
        return bson;
    }

    @NotNull
    public Bson notIn(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        String string = condition.getField();
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Bson bson = Filters.nin((String)string, (Iterable)((List)object));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"nin(...)");
        return bson;
    }

    @NotNull
    public Bson between(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<kotlin.Any>");
        Iterable valueIterable = (Iterable)object;
        Iterator ite = valueIterable.iterator();
        if (!ite.hasNext()) {
            boolean $i$a$-require-MongoConditionConverter$between$32 = false;
            String $i$a$-require-MongoConditionConverter$between$32 = "BETWEEN operator value must be a array with 2 elements.";
            throw new IllegalArgumentException($i$a$-require-MongoConditionConverter$between$32.toString());
        }
        Object first = ite.next();
        if (!ite.hasNext()) {
            boolean bl = false;
            String string = "BETWEEN operator value must be a array with 2 elements.";
            throw new IllegalArgumentException(string.toString());
        }
        Object second = ite.next();
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), first), Filters.lte((String)condition.getField(), second)};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson allIn(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        String string = condition.getField();
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Bson bson = Filters.all((String)string, (Iterable)((List)object));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"all(...)");
        return bson;
    }

    @NotNull
    public Bson startsWith(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.regex((String)condition.getField(), (String)("^" + condition.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"regex(...)");
        return bson;
    }

    @NotNull
    public Bson endsWith(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.regex((String)condition.getField(), (String)(condition.getValue() + "$"));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"regex(...)");
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bson elemMatch(@NotNull Condition condition) {
        void it;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Condition condition2 = (Condition)CollectionsKt.first((List)condition.getChildren());
        String string = condition.getField();
        boolean bl = false;
        Bson bson = Filters.elemMatch((String)string, (Bson)((Bson)INSTANCE.convert((Condition)it)));
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"elemMatch(...)");
        return bson;
    }

    @NotNull
    public Bson isNull(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), null);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson notNull(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.ne((String)condition.getField(), null);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"ne(...)");
        return bson;
    }

    @NotNull
    public Bson isTrue(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson isFalse(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)condition.getField(), (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson deleted(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson bson = Filters.eq((String)"deleted", (Object)condition.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public Bson today(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfDay = LocalDateTime.now().with(LocalTime.MIN);
        LocalDateTime endOfDay = LocalDateTime.now().with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfDay.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfDay.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson tomorrow(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfTomorrow = LocalDateTime.now().plusDays(1L).with(LocalTime.MIN);
        LocalDateTime endOfTomorrow = LocalDateTime.now().plusDays(1L).with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfTomorrow.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfTomorrow.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson thisWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfWeek = LocalDateTime.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        LocalDateTime endOfWeek = LocalDateTime.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfWeek.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfWeek.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson nextWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfNextWeek = LocalDateTime.now().plusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        LocalDateTime endOfNextWeek = LocalDateTime.now().plusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfNextWeek.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfNextWeek.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson lastWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfLastWeek = LocalDateTime.now().minusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        LocalDateTime endOfLastWeek = LocalDateTime.now().minusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfLastWeek.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfLastWeek.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson thisMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfMonth = LocalDateTime.now().withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime endOfMonth = LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfMonth.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfMonth.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson lastMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfLastMonth = LocalDateTime.now().minusMonths(1L).withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime endOfLastMonth = LocalDateTime.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfLastMonth.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfLastMonth.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson recentDays(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        Number days = (Number)object;
        LocalDateTime startOfRecentDays = LocalDateTime.now().minusDays(days.longValue() - 1L).with(LocalTime.MIN);
        LocalDateTime endOfRecentDays = LocalDateTime.now().with(LocalTime.MAX);
        Bson[] bsonArray = new Bson[]{Filters.gte((String)condition.getField(), (Object)startOfRecentDays.toInstant(ZoneOffset.UTC).toEpochMilli()), Filters.lte((String)condition.getField(), (Object)endOfRecentDays.toInstant(ZoneOffset.UTC).toEpochMilli())};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }

    @NotNull
    public Bson raw(@NotNull Condition condition) {
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = condition.getValue();
        if (object instanceof Bson) {
            Object object2 = condition.getValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.bson.conversions.Bson");
            bson = (Bson)object2;
        } else if (object instanceof String) {
            Object object3 = condition.getValue();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
            Document document = Document.parse((String)((String)object3));
            Intrinsics.checkNotNull((Object)document);
            bson = (Bson)document;
        } else if (object instanceof Map) {
            Object object4 = condition.getValue();
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            bson = (Bson)new Document((Map)object4);
        } else {
            String conditionValueJson = JsonSerializerKt.toJsonString((Object)condition.getValue());
            Document document = Document.parse((String)conditionValueJson);
            Intrinsics.checkNotNull((Object)document);
            bson = (Bson)document;
        }
        return bson;
    }

    @NotNull
    public Bson not(boolean not, @NotNull Bson target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!not) {
            return target;
        }
        Bson bson = Filters.not((Bson)target);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"not(...)");
        return bson;
    }

    @NotNull
    public final Bson toMongoFilter(@NotNull Condition $this$toMongoFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$toMongoFilter, (String)"<this>");
        return (Bson)this.convert($this$toMongoFilter);
    }
}

