/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.AbstractEventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/mongo/MongoEventStore;", "Lme/ahoo/wow/eventsourcing/AbstractEventStore;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "<init>", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "appendStream", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "findStream", "Lreactor/core/publisher/Flux;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "filter", "Lorg/bson/conversions/Bson;", "loadStream", "headVersion", "", "tailVersion", "headEventTime", "", "tailEventTime", "Companion", "wow-mongo"})
@SourceDebugExtension(value={"SMAP\nMongoEventStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoEventStore.kt\nme/ahoo/wow/mongo/MongoEventStore\n+ 2 JsonSerializer.kt\nme/ahoo/wow/serialization/JsonSerializerKt\n*L\n1#1,120:1\n67#2:121\n*S KotlinDebug\n*F\n+ 1 MongoEventStore.kt\nme/ahoo/wow/mongo/MongoEventStore\n*L\n86#1:121\n*E\n"})
public final class MongoEventStore
extends AbstractEventStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private static final String SIZE_FIELD = "size";

    public MongoEventStore(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    protected Mono<Void> appendStream(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName((NamedAggregate)eventStream);
        String eventStreamJson = JsonSerializerKt.toJsonString((Object)eventStream);
        Document document = Document.parse((String)eventStreamJson);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = Documents.INSTANCE.replaceIdToPrimaryKey(document).append(SIZE_FIELD, (Object)eventStream.getSize());
        Publisher publisher = this.database.getCollection(eventStreamCollectionName).insertOne((Object)document2);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"insertOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).doOnNext(arg_0 -> MongoEventStore.appendStream$lambda$1(MongoEventStore::appendStream$lambda$0, arg_0)).onErrorMap(MongoWriteException.class, arg_0 -> MongoEventStore.appendStream$lambda$3(arg_0 -> MongoEventStore.appendStream$lambda$2(eventStream, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private final Flux<DomainEventStream> findStream(AggregateId aggregateId, Bson filter) {
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName((NamedAggregate)aggregateId);
        String[] stringArray = new String[]{"version"};
        FindPublisher findPublisher = this.database.getCollection(eventStreamCollectionName).find(filter).sort(Sorts.ascending((String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"sort(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoEventStore.findStream$lambda$6(arg_0 -> MongoEventStore.findStream$lambda$5(aggregateId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    protected Flux<DomainEventStream> loadStream(@NotNull AggregateId aggregateId, int headVersion, int tailVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"aggregateId", (Object)aggregateId.getId()), Filters.gte((String)"version", (Object)headVersion), Filters.lte((String)"version", (Object)tailVersion)};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return this.findStream(aggregateId, bson);
    }

    @NotNull
    protected Flux<DomainEventStream> loadStream(@NotNull AggregateId aggregateId, long headEventTime, long tailEventTime) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"aggregateId", (Object)aggregateId.getId()), Filters.gte((String)"createTime", (Object)headEventTime), Filters.lte((String)"createTime", (Object)tailEventTime)};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return this.findStream(aggregateId, bson);
    }

    private static final Unit appendStream$lambda$0(InsertOneResult it) {
        if (!it.wasAcknowledged()) {
            throw new IllegalStateException("Check failed.");
        }
        return Unit.INSTANCE;
    }

    private static final void appendStream$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Throwable appendStream$lambda$2(DomainEventStream $eventStream, MongoWriteException it) {
        if (ErrorCategory.fromErrorCode((int)it.getCode()) != ErrorCategory.DUPLICATE_KEY) {
            return (Throwable)it;
        }
        String string = it.getMessage();
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"aggregateId_1_version_1", (boolean)false, (int)2, null)) {
            return (Throwable)new EventVersionConflictException($eventStream, null, (Throwable)it, 2, null);
        }
        String string2 = it.getMessage();
        Intrinsics.checkNotNull((Object)string2);
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"requestId_1", (boolean)false, (int)2, null)) {
            return (Throwable)new DuplicateRequestIdException($eventStream.getAggregateId(), $eventStream.getRequestId(), null, (Throwable)it, 4, null);
        }
        return (Throwable)it;
    }

    private static final Throwable appendStream$lambda$3(Function1 $tmp0, Object p0) {
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final DomainEventStream findStream$lambda$5(AggregateId $aggregateId, Document it) {
        Intrinsics.checkNotNull((Object)it);
        String string = Documents.INSTANCE.replacePrimaryKeyToId(it).toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String $this$toObject$iv = string;
        boolean $i$f$toObject = false;
        DomainEventStream domainEventStream = (DomainEventStream)JsonSerializerKt.toObject((String)$this$toObject$iv, DomainEventStream.class);
        if (!Intrinsics.areEqual((Object)domainEventStream.getAggregateId(), (Object)$aggregateId)) {
            boolean bl = false;
            String string2 = "aggregateId is not match! aggregateId: " + $aggregateId + ", domainEventStream: " + domainEventStream.getAggregateId();
            throw new IllegalArgumentException(string2.toString());
        }
        return domainEventStream;
    }

    private static final DomainEventStream findStream$lambda$6(Function1 $tmp0, Object p0) {
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/mongo/MongoEventStore$Companion;", "", "<init>", "()V", "SIZE_FIELD", "", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

