/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.reactivestreams.client.ListCollectionNamesPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.infra.accessor.function.reactive.BlockingMonoFunctionAccessorKt;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u00020\u0007*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\u0007*\u00020\u000eJ\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u0018\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u0019\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u001a\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u001b\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u001c\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00170\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/ahoo/wow/mongo/AggregateSchemaInitializer;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "AGGREGATE_ID_AND_VERSION_UNIQUE_INDEX_NAME", "", "REQUEST_ID_UNIQUE_INDEX_NAME", "uniqueIndexOptions", "Lcom/mongodb/client/model/IndexOptions;", "EVENT_STREAM_COLLECTION_SUFFIX", "SNAPSHOT_COLLECTION_SUFFIX", "toEventStreamCollectionName", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "toSnapshotCollectionName", "ensureCollection", "", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "collectionName", "createAggregateIdIndex", "", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "createAggregateIdAndVersionUniqueIndex", "createRequestIdUniqueIndex", "createAggregateIdAndRequestIdUniqueIndex", "createTenantIdIndex", "createOwnerIdIndex", "wow-mongo"})
public final class AggregateSchemaInitializer {
    @NotNull
    public static final AggregateSchemaInitializer INSTANCE = new AggregateSchemaInitializer();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(AggregateSchemaInitializer::log$lambda$0);
    @NotNull
    public static final String AGGREGATE_ID_AND_VERSION_UNIQUE_INDEX_NAME = "aggregateId_1_version_1";
    @NotNull
    public static final String REQUEST_ID_UNIQUE_INDEX_NAME = "requestId_1";
    @NotNull
    private static final IndexOptions uniqueIndexOptions;
    @NotNull
    private static final String EVENT_STREAM_COLLECTION_SUFFIX = "_event_stream";
    @NotNull
    private static final String SNAPSHOT_COLLECTION_SUFFIX = "_snapshot";

    private AggregateSchemaInitializer() {
    }

    @NotNull
    public final String toEventStreamCollectionName(@NotNull NamedAggregate $this$toEventStreamCollectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$toEventStreamCollectionName, (String)"<this>");
        return $this$toEventStreamCollectionName.getAggregateName() + EVENT_STREAM_COLLECTION_SUFFIX;
    }

    @NotNull
    public final String toSnapshotCollectionName(@NotNull NamedAggregate $this$toSnapshotCollectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$toSnapshotCollectionName, (String)"<this>");
        return $this$toSnapshotCollectionName.getAggregateName() + SNAPSHOT_COLLECTION_SUFFIX;
    }

    public final boolean ensureCollection(@NotNull MongoDatabase $this$ensureCollection, @NotNull String collectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureCollection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        ListCollectionNamesPublisher listCollectionNamesPublisher = $this$ensureCollection.listCollectionNames();
        Intrinsics.checkNotNullExpressionValue((Object)listCollectionNamesPublisher, (String)"listCollectionNames(...)");
        Mono mono = FluxExtensionsKt.toFlux((Publisher)((Publisher)listCollectionNamesPublisher)).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        Object object = BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)mono, null, (int)1, null).block();
        Intrinsics.checkNotNull((Object)object);
        List it = (List)object;
        boolean bl = false;
        if (it.contains(collectionName)) {
            log.info(() -> AggregateSchemaInitializer.ensureCollection$lambda$4$lambda$1(collectionName));
            return false;
        }
        log.info(() -> AggregateSchemaInitializer.ensureCollection$lambda$4$lambda$2(collectionName));
        Publisher publisher = $this$ensureCollection.createCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createCollection(...)");
        MonoExtensionsKt.toMono((Publisher)publisher).block();
        log.info(() -> AggregateSchemaInitializer.ensureCollection$lambda$4$lambda$3(collectionName));
        return true;
    }

    public final void createAggregateIdIndex(@NotNull MongoCollection<Document> $this$createAggregateIdIndex) {
        Intrinsics.checkNotNullParameter($this$createAggregateIdIndex, (String)"<this>");
        Publisher publisher = $this$createAggregateIdIndex.createIndex(Indexes.hashed((String)"aggregateId"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createAggregateIdAndVersionUniqueIndex(@NotNull MongoCollection<Document> $this$createAggregateIdAndVersionUniqueIndex) {
        Intrinsics.checkNotNullParameter($this$createAggregateIdAndVersionUniqueIndex, (String)"<this>");
        String[] stringArray = new String[]{"aggregateId", "version"};
        Publisher publisher = $this$createAggregateIdAndVersionUniqueIndex.createIndex(Indexes.ascending((String[])stringArray), uniqueIndexOptions);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createRequestIdUniqueIndex(@NotNull MongoCollection<Document> $this$createRequestIdUniqueIndex) {
        Intrinsics.checkNotNullParameter($this$createRequestIdUniqueIndex, (String)"<this>");
        String[] stringArray = new String[]{"requestId"};
        Publisher publisher = $this$createRequestIdUniqueIndex.createIndex(Indexes.ascending((String[])stringArray), uniqueIndexOptions);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createAggregateIdAndRequestIdUniqueIndex(@NotNull MongoCollection<Document> $this$createAggregateIdAndRequestIdUniqueIndex) {
        Intrinsics.checkNotNullParameter($this$createAggregateIdAndRequestIdUniqueIndex, (String)"<this>");
        String[] stringArray = new String[]{"aggregateId", "requestId"};
        Publisher publisher = $this$createAggregateIdAndRequestIdUniqueIndex.createIndex(Indexes.ascending((String[])stringArray), uniqueIndexOptions);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createTenantIdIndex(@NotNull MongoCollection<Document> $this$createTenantIdIndex) {
        Intrinsics.checkNotNullParameter($this$createTenantIdIndex, (String)"<this>");
        Publisher publisher = $this$createTenantIdIndex.createIndex(Indexes.hashed((String)"tenantId"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createOwnerIdIndex(@NotNull MongoCollection<Document> $this$createOwnerIdIndex) {
        Intrinsics.checkNotNullParameter($this$createOwnerIdIndex, (String)"<this>");
        Publisher publisher = $this$createOwnerIdIndex.createIndex(Indexes.hashed((String)"ownerId"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object ensureCollection$lambda$4$lambda$1(String $collectionName) {
        return "Ensure Collection [" + $collectionName + " already exists,ignore create.";
    }

    private static final Object ensureCollection$lambda$4$lambda$2(String $collectionName) {
        return "Ensure Collection [" + $collectionName + "] Creating.";
    }

    private static final Object ensureCollection$lambda$4$lambda$3(String $collectionName) {
        return "Ensure Collection [" + $collectionName + "] Creating.";
    }

    static {
        IndexOptions indexOptions = new IndexOptions().unique(true);
        Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"unique(...)");
        uniqueIndexOptions = indexOptions;
    }
}

