/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.client.model.Indexes;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.infra.accessor.function.reactive.BlockingMonoFunctionAccessorKt;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/mongo/SnapshotSchemaInitializer;", "", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "<init>", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "initAll", "", "initSchema", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "Companion", "wow-mongo"})
public final class SnapshotSchemaInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(SnapshotSchemaInitializer::log$lambda$3);

    public SnapshotSchemaInitializer(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    public final void initAll() {
        MetadataSearcher.INSTANCE.getNamedAggregateType().forEach((arg_0, arg_1) -> SnapshotSchemaInitializer.initAll$lambda$1((arg_0, arg_1) -> SnapshotSchemaInitializer.initAll$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
    }

    public final void initSchema(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String collectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName(namedAggregate);
        log.info(() -> SnapshotSchemaInitializer.initSchema$lambda$2(namedAggregate, this, collectionName));
        if (!AggregateSchemaInitializer.INSTANCE.ensureCollection(this.database, collectionName)) {
            return;
        }
        MongoCollection mongoCollection = this.database.getCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection snapshotCollection = mongoCollection;
        AggregateSchemaInitializer.INSTANCE.createTenantIdIndex((MongoCollection<Document>)snapshotCollection);
        AggregateSchemaInitializer.INSTANCE.createOwnerIdIndex((MongoCollection<Document>)snapshotCollection);
        Publisher publisher = snapshotCollection.createIndex(Indexes.hashed((String)"_id"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
        Publisher publisher2 = snapshotCollection.createIndex(Indexes.hashed((String)"deleted"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher2, (String)"createIndex(...)");
        BlockingMonoFunctionAccessorKt.toBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher2), null, (int)1, null).block();
    }

    private static final Unit initAll$lambda$0(SnapshotSchemaInitializer this$0, MaterializedNamedAggregate namedAggregate, Class clazz) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"<unused var>");
        this$0.initSchema((NamedAggregate)namedAggregate);
        return Unit.INSTANCE;
    }

    private static final void initAll$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Object initSchema$lambda$2(NamedAggregate $namedAggregate, SnapshotSchemaInitializer this$0, String $collectionName) {
        return "Init NamedAggregate Schema [" + $namedAggregate + "] to Database:[" + this$0.database.getName() + "] CollectionName [" + $collectionName + "]";
    }

    private static final Unit log$lambda$3() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/mongo/SnapshotSchemaInitializer$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

