/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.DynamicDocument;
import me.ahoo.wow.api.query.IListQuery;
import me.ahoo.wow.api.query.IPagedQuery;
import me.ahoo.wow.api.query.ISingleQuery;
import me.ahoo.wow.api.query.PagedList;
import me.ahoo.wow.api.query.Queryable;
import me.ahoo.wow.mongo.query.MongoCollectionsKt;
import me.ahoo.wow.mongo.query.MongoProjectionConverter;
import me.ahoo.wow.mongo.query.MongoSortConverter;
import me.ahoo.wow.query.QueryService;
import me.ahoo.wow.query.converter.ConditionConverter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.util.function.Tuple2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\bH&J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0004J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0(2\u0006\u0010)\u001a\u00020*H\u0016J6\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0.0\"\"\u0004\b\u0001\u0010/2\u0006\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H/03H\u0002J\u001c\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000.0\"2\u0006\u00100\u001a\u000201H\u0016J\u001c\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0.0\"2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002070\"2\u0006\u00108\u001a\u000209H\u0016R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006:"}, d2={"Lme/ahoo/wow/mongo/query/AbstractMongoQueryService;", "R", "", "Lme/ahoo/wow/query/QueryService;", "<init>", "()V", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "getCollection", "()Lcom/mongodb/reactivestreams/client/MongoCollection;", "converter", "Lme/ahoo/wow/query/converter/ConditionConverter;", "Lorg/bson/conversions/Bson;", "getConverter", "()Lme/ahoo/wow/query/converter/ConditionConverter;", "projectionConverter", "Lme/ahoo/wow/mongo/query/MongoProjectionConverter;", "getProjectionConverter", "()Lme/ahoo/wow/mongo/query/MongoProjectionConverter;", "sortConverter", "Lme/ahoo/wow/mongo/query/MongoSortConverter;", "getSortConverter", "()Lme/ahoo/wow/mongo/query/MongoSortConverter;", "toTypedResult", "document", "(Lorg/bson/Document;)Ljava/lang/Object;", "toDynamicDocument", "Lme/ahoo/wow/api/query/DynamicDocument;", "findDocument", "Lcom/mongodb/reactivestreams/client/FindPublisher;", "queryable", "Lme/ahoo/wow/api/query/Queryable;", "singleDocument", "Lreactor/core/publisher/Mono;", "singleQuery", "Lme/ahoo/wow/api/query/ISingleQuery;", "single", "dynamicSingle", "listDocument", "Lreactor/core/publisher/Flux;", "listQuery", "Lme/ahoo/wow/api/query/IListQuery;", "list", "dynamicList", "pagedDocument", "Lme/ahoo/wow/api/query/PagedList;", "T", "pagedQuery", "Lme/ahoo/wow/api/query/IPagedQuery;", "documentMapper", "Lkotlin/Function1;", "paged", "dynamicPaged", "count", "", "condition", "Lme/ahoo/wow/api/query/Condition;", "wow-mongo"})
public abstract class AbstractMongoQueryService<R>
implements QueryService<R> {
    @NotNull
    public abstract MongoCollection<Document> getCollection();

    @NotNull
    public abstract ConditionConverter<Bson> getConverter();

    @NotNull
    public abstract MongoProjectionConverter getProjectionConverter();

    @NotNull
    public abstract MongoSortConverter getSortConverter();

    @NotNull
    public abstract R toTypedResult(@NotNull Document var1);

    @NotNull
    public abstract DynamicDocument toDynamicDocument(@NotNull Document var1);

    @NotNull
    protected final FindPublisher<Document> findDocument(@NotNull Queryable<?> queryable) {
        Intrinsics.checkNotNullParameter(queryable, (String)"queryable");
        return MongoCollectionsKt.findDocument(this.getCollection(), this.getConverter(), queryable, this.getProjectionConverter(), this.getSortConverter());
    }

    private final Mono<Document> singleDocument(ISingleQuery singleQuery) {
        Publisher publisher = this.findDocument((Queryable)singleQuery).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    @NotNull
    public Mono<R> single(@NotNull ISingleQuery singleQuery) {
        Intrinsics.checkNotNullParameter((Object)singleQuery, (String)"singleQuery");
        Mono mono = this.singleDocument(singleQuery).map(arg_0 -> AbstractMongoQueryService.single$lambda$1(arg_0 -> AbstractMongoQueryService.single$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<DynamicDocument> dynamicSingle(@NotNull ISingleQuery singleQuery) {
        Intrinsics.checkNotNullParameter((Object)singleQuery, (String)"singleQuery");
        Mono mono = this.singleDocument(singleQuery).map(arg_0 -> AbstractMongoQueryService.dynamicSingle$lambda$3(arg_0 -> AbstractMongoQueryService.dynamicSingle$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private final Flux<Document> listDocument(IListQuery listQuery) {
        FindPublisher findPublisher = this.findDocument((Queryable)listQuery).limit(listQuery.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        return FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher));
    }

    @NotNull
    public Flux<R> list(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        Flux flux = this.listDocument(listQuery).map(arg_0 -> AbstractMongoQueryService.list$lambda$5(arg_0 -> AbstractMongoQueryService.list$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flux<DynamicDocument> dynamicList(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        Flux flux = this.listDocument(listQuery).map(arg_0 -> AbstractMongoQueryService.dynamicList$lambda$7(arg_0 -> AbstractMongoQueryService.dynamicList$lambda$6(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    private final <T> Mono<PagedList<T>> pagedDocument(IPagedQuery pagedQuery, Function1<? super Document, ? extends T> documentMapper) {
        Bson projectionBson = (Bson)this.getProjectionConverter().convert(pagedQuery.getProjection());
        Bson filter = (Bson)this.getConverter().convert(pagedQuery.getCondition());
        Bson sort = (Bson)this.getSortConverter().convert(pagedQuery.getSort());
        Publisher publisher = this.getCollection().countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        Mono totalPublisher = MonoExtensionsKt.toMono((Publisher)publisher);
        FindPublisher findPublisher = this.getCollection().find(filter).projection(projectionBson).sort(sort).skip(pagedQuery.getPagination().offset()).limit(pagedQuery.getPagination().getSize()).batchSize(pagedQuery.getPagination().getSize());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"batchSize(...)");
        Flux listPublisher = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher));
        Mono mono = listPublisher.map(arg_0 -> AbstractMongoQueryService.pagedDocument$lambda$9(arg_0 -> AbstractMongoQueryService.pagedDocument$lambda$8(documentMapper, arg_0), arg_0)).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        Mono listMappedPublisher = mono;
        Mono mono2 = Mono.zip((Mono)totalPublisher, (Mono)listMappedPublisher).map(arg_0 -> AbstractMongoQueryService.pagedDocument$lambda$11(AbstractMongoQueryService::pagedDocument$lambda$10, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"map(...)");
        return mono2;
    }

    @NotNull
    public Mono<PagedList<R>> paged(@NotNull IPagedQuery pagedQuery) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery, (String)"pagedQuery");
        return this.pagedDocument(pagedQuery, arg_0 -> AbstractMongoQueryService.paged$lambda$12(this, arg_0));
    }

    @NotNull
    public Mono<PagedList<DynamicDocument>> dynamicPaged(@NotNull IPagedQuery pagedQuery) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery, (String)"pagedQuery");
        return this.pagedDocument(pagedQuery, arg_0 -> AbstractMongoQueryService.dynamicPaged$lambda$13(this, arg_0));
    }

    @NotNull
    public Mono<Long> count(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson filter = (Bson)this.getConverter().convert(condition);
        Publisher publisher = this.getCollection().countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    private static final Object single$lambda$0(AbstractMongoQueryService this$0, Document it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.toTypedResult(it);
    }

    private static final Object single$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final DynamicDocument dynamicSingle$lambda$2(AbstractMongoQueryService this$0, Document it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.toDynamicDocument(it);
    }

    private static final DynamicDocument dynamicSingle$lambda$3(Function1 $tmp0, Object p0) {
        return (DynamicDocument)$tmp0.invoke(p0);
    }

    private static final Object list$lambda$4(AbstractMongoQueryService this$0, Document it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.toTypedResult(it);
    }

    private static final Object list$lambda$5(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final DynamicDocument dynamicList$lambda$6(AbstractMongoQueryService this$0, Document it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.toDynamicDocument(it);
    }

    private static final DynamicDocument dynamicList$lambda$7(Function1 $tmp0, Object p0) {
        return (DynamicDocument)$tmp0.invoke(p0);
    }

    private static final Object pagedDocument$lambda$8(Function1 $documentMapper, Document it) {
        Intrinsics.checkNotNull((Object)it);
        return $documentMapper.invoke((Object)it);
    }

    private static final Object pagedDocument$lambda$9(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final PagedList pagedDocument$lambda$10(Tuple2 result) {
        Object object = result.getT1();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getT1(...)");
        long l = ((Number)object).longValue();
        Object object2 = result.getT2();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getT2(...)");
        return new PagedList(l, (List)object2);
    }

    private static final PagedList pagedDocument$lambda$11(Function1 $tmp0, Object p0) {
        return (PagedList)$tmp0.invoke(p0);
    }

    private static final Object paged$lambda$12(AbstractMongoQueryService this$0, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.toTypedResult(it);
    }

    private static final DynamicDocument dynamicPaged$lambda$13(AbstractMongoQueryService this$0, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.toDynamicDocument(it);
    }
}

