/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query.snapshot;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.DynamicDocument;
import me.ahoo.wow.api.query.MaterializedSnapshot;
import me.ahoo.wow.api.query.SimpleDynamicDocument;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.query.AbstractMongoQueryService;
import me.ahoo.wow.mongo.query.MongoProjectionConverter;
import me.ahoo.wow.mongo.query.MongoSortConverter;
import me.ahoo.wow.mongo.query.snapshot.SnapshotConditionConverter;
import me.ahoo.wow.mongo.query.snapshot.SnapshotFieldConverter;
import me.ahoo.wow.query.converter.ConditionConverter;
import me.ahoo.wow.query.snapshot.SnapshotQueryService;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lme/ahoo/wow/mongo/query/snapshot/MongoSnapshotQueryService;", "S", "", "Lme/ahoo/wow/mongo/query/AbstractMongoQueryService;", "Lme/ahoo/wow/api/query/MaterializedSnapshot;", "Lme/ahoo/wow/query/snapshot/SnapshotQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "converter", "Lme/ahoo/wow/query/converter/ConditionConverter;", "Lorg/bson/conversions/Bson;", "<init>", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lcom/mongodb/reactivestreams/client/MongoCollection;Lme/ahoo/wow/query/converter/ConditionConverter;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "getCollection", "()Lcom/mongodb/reactivestreams/client/MongoCollection;", "getConverter", "()Lme/ahoo/wow/query/converter/ConditionConverter;", "name", "", "getName", "()Ljava/lang/String;", "projectionConverter", "Lme/ahoo/wow/mongo/query/MongoProjectionConverter;", "getProjectionConverter", "()Lme/ahoo/wow/mongo/query/MongoProjectionConverter;", "sortConverter", "Lme/ahoo/wow/mongo/query/MongoSortConverter;", "getSortConverter", "()Lme/ahoo/wow/mongo/query/MongoSortConverter;", "snapshotType", "Lcom/fasterxml/jackson/databind/JavaType;", "kotlin.jvm.PlatformType", "toTypedResult", "document", "toDynamicDocument", "Lme/ahoo/wow/api/query/DynamicDocument;", "wow-mongo"})
public final class MongoSnapshotQueryService<S>
extends AbstractMongoQueryService<MaterializedSnapshot<S>>
implements SnapshotQueryService<S> {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final MongoCollection<Document> collection;
    @NotNull
    private final ConditionConverter<Bson> converter;
    @NotNull
    private final MongoProjectionConverter projectionConverter;
    @NotNull
    private final MongoSortConverter sortConverter;
    private final JavaType snapshotType;

    public MongoSnapshotQueryService(@NotNull NamedAggregate namedAggregate, @NotNull MongoCollection<Document> collection, @NotNull ConditionConverter<Bson> converter) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.namedAggregate = namedAggregate;
        this.collection = collection;
        this.converter = converter;
        this.projectionConverter = new MongoProjectionConverter(SnapshotFieldConverter.INSTANCE);
        this.sortConverter = new MongoSortConverter(SnapshotFieldConverter.INSTANCE);
        Class[] classArray = new Class[]{AggregateMetadataParserKt.aggregateMetadata((Class)MetadataSearcherKt.requiredAggregateType((NamedAggregate)this.getNamedAggregate())).getState().getAggregateType()};
        this.snapshotType = TypeFactory.defaultInstance().constructParametricType(MaterializedSnapshot.class, classArray);
    }

    public /* synthetic */ MongoSnapshotQueryService(NamedAggregate namedAggregate, MongoCollection mongoCollection, ConditionConverter conditionConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            conditionConverter = (ConditionConverter)SnapshotConditionConverter.INSTANCE;
        }
        this(namedAggregate, (MongoCollection<Document>)mongoCollection, (ConditionConverter<Bson>)conditionConverter);
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @Override
    @NotNull
    public MongoCollection<Document> getCollection() {
        return this.collection;
    }

    @Override
    @NotNull
    public ConditionConverter<Bson> getConverter() {
        return this.converter;
    }

    @NotNull
    public String getName() {
        return "mongo";
    }

    @Override
    @NotNull
    public MongoProjectionConverter getProjectionConverter() {
        return this.projectionConverter;
    }

    @Override
    @NotNull
    public MongoSortConverter getSortConverter() {
        return this.sortConverter;
    }

    @Override
    @NotNull
    public MaterializedSnapshot<S> toTypedResult(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaType javaType = this.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        return DocumentsKt.toMaterializedSnapshot(document, javaType);
    }

    @Override
    @NotNull
    public DynamicDocument toDynamicDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (DynamicDocument)SimpleDynamicDocument.Companion.toDynamicDocument((Map)Documents.INSTANCE.replacePrimaryKeyToAggregateId(document));
    }
}

