/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/mongo/EventStreamSchemaInitializer;", "", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "enableRequestIdUniqueIndex", "", "<init>", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;Z)V", "initAll", "", "initSchema", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "Companion", "wow-mongo"})
public final class EventStreamSchemaInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    private final boolean enableRequestIdUniqueIndex;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(EventStreamSchemaInitializer::log$lambda$0);

    public EventStreamSchemaInitializer(@NotNull MongoDatabase database, boolean enableRequestIdUniqueIndex) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.enableRequestIdUniqueIndex = enableRequestIdUniqueIndex;
    }

    public /* synthetic */ EventStreamSchemaInitializer(MongoDatabase mongoDatabase, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(mongoDatabase, bl);
    }

    public final void initAll() {
        MetadataSearcher.INSTANCE.getNamedAggregateType().forEach((arg_0, arg_1) -> EventStreamSchemaInitializer.initAll$lambda$1((arg_0, arg_1) -> EventStreamSchemaInitializer.initAll$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
    }

    public final void initSchema(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String collectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName(namedAggregate);
        log.info(() -> EventStreamSchemaInitializer.initSchema$lambda$0(namedAggregate, this, collectionName));
        if (!AggregateSchemaInitializer.INSTANCE.ensureCollection(this.database, collectionName)) {
            return;
        }
        MongoCollection mongoCollection = this.database.getCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection eventStreamCollection = mongoCollection;
        AggregateSchemaInitializer.INSTANCE.createAggregateIdIndex((MongoCollection<Document>)eventStreamCollection);
        AggregateSchemaInitializer.INSTANCE.createAggregateIdAndVersionUniqueIndex((MongoCollection<Document>)eventStreamCollection);
        if (this.enableRequestIdUniqueIndex) {
            AggregateSchemaInitializer.INSTANCE.createRequestIdUniqueIndex((MongoCollection<Document>)eventStreamCollection);
        } else {
            AggregateSchemaInitializer.INSTANCE.createAggregateIdAndRequestIdUniqueIndex((MongoCollection<Document>)eventStreamCollection);
        }
        AggregateSchemaInitializer.INSTANCE.createTenantIdIndex((MongoCollection<Document>)eventStreamCollection);
        AggregateSchemaInitializer.INSTANCE.createOwnerIdIndex((MongoCollection<Document>)eventStreamCollection);
    }

    private static final Unit initAll$lambda$0(EventStreamSchemaInitializer this$0, MaterializedNamedAggregate namedAggregate, Class clazz) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"<unused var>");
        this$0.initSchema((NamedAggregate)namedAggregate);
        return Unit.INSTANCE;
    }

    private static final void initAll$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Object initSchema$lambda$0(NamedAggregate $namedAggregate, EventStreamSchemaInitializer this$0, String $collectionName) {
        return "Init NamedAggregate Schema [" + $namedAggregate + "] to Database:[" + this$0.database.getName() + "] CollectionName [" + $collectionName + "]";
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/mongo/EventStreamSchemaInitializer$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

