/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f0\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\r0\fH\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lme/ahoo/wow/mongo/MongoSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "<init>", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "name", "", "getName", "()Ljava/lang/String;", "load", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "getVersion", "", "mapSnapshot", "document", "Lorg/bson/Document;", "save", "Ljava/lang/Void;", "snapshot", "scanAggregateId", "Lreactor/core/publisher/Flux;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "afterId", "limit", "Companion", "wow-mongo"})
public final class MongoSnapshotRepository
implements SnapshotRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    public static final String NAME = "mongo";
    @NotNull
    private static final ReplaceOptions DEFAULT_REPLACE_OPTIONS;

    public MongoSnapshotRepository(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName((NamedAggregate)aggregateId);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).find(Filters.eq((String)"_id", (Object)aggregateId.getId())).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoSnapshotRepository.load$lambda$1(arg_0 -> MongoSnapshotRepository.load$lambda$0(this, aggregateId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<Integer> getVersion(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName((NamedAggregate)aggregateId);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).find(Filters.eq((String)"_id", (Object)aggregateId.getId())).projection((Bson)new Document("version", (Object)1)).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoSnapshotRepository.getVersion$lambda$1(MongoSnapshotRepository::getVersion$lambda$0, arg_0)).defaultIfEmpty((Object)0);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defaultIfEmpty(...)");
        return mono;
    }

    private final <S> Snapshot<S> mapSnapshot(AggregateId aggregateId, Document document) {
        Snapshot snapshot = DocumentsKt.toSnapshot(document);
        if (!Intrinsics.areEqual((Object)aggregateId, (Object)snapshot.getAggregateId())) {
            boolean bl = false;
            String string = "aggregateId: " + aggregateId + " != snapshot.aggregateId: " + snapshot.getAggregateId();
            throw new IllegalArgumentException(string.toString());
        }
        return snapshot;
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName((NamedAggregate)snapshot.getAggregateId());
        String snapshotJsonString = JsonSerializerKt.toJsonString(snapshot);
        Document document = Document.parse((String)snapshotJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = Documents.INSTANCE.replaceAggregateIdToPrimaryKey(document);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).replaceOne(Filters.eq((String)"_id", (Object)snapshot.getAggregateId().getId()), (Object)document2, DEFAULT_REPLACE_OPTIONS);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"replaceOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).doOnNext(arg_0 -> MongoSnapshotRepository.save$lambda$1(MongoSnapshotRepository::save$lambda$0, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    public Flux<AggregateId> scanAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String afterId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)afterId, (String)"afterId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.toSnapshotCollectionName(namedAggregate);
        String[] stringArray = new String[]{"tenantId"};
        FindPublisher findPublisher = this.database.getCollection(snapshotCollectionName).find(Filters.gt((String)"_id", (Object)afterId)).projection(Projections.include((String[])stringArray)).limit(limit);
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoSnapshotRepository.scanAggregateId$lambda$1(arg_0 -> MongoSnapshotRepository.scanAggregateId$lambda$0(namedAggregate, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    private static final Snapshot load$lambda$0(MongoSnapshotRepository this$0, AggregateId $aggregateId, Document it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.mapSnapshot($aggregateId, it);
    }

    private static final Snapshot load$lambda$1(Function1 $tmp0, Object p0) {
        return (Snapshot)$tmp0.invoke(p0);
    }

    private static final Integer getVersion$lambda$0(Document it) {
        return it.getInteger((Object)"version");
    }

    private static final Integer getVersion$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Unit save$lambda$0(UpdateResult it) {
        if (!it.wasAcknowledged()) {
            throw new IllegalStateException("Check failed.");
        }
        return Unit.INSTANCE;
    }

    private static final void save$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final AggregateId scanAggregateId$lambda$0(NamedAggregate $namedAggregate, Document it) {
        String aggregateId = it.getString((Object)"_id");
        String tenantId = it.getString((Object)"tenantId");
        Intrinsics.checkNotNull((Object)aggregateId);
        Intrinsics.checkNotNull((Object)tenantId);
        return (AggregateId)DefaultAggregateIdKt.aggregateId((NamedAggregate)$namedAggregate, (String)aggregateId, (String)tenantId);
    }

    private static final AggregateId scanAggregateId$lambda$1(Function1 $tmp0, Object p0) {
        return (AggregateId)$tmp0.invoke(p0);
    }

    static {
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        DEFAULT_REPLACE_OPTIONS = replaceOptions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/mongo/MongoSnapshotRepository$Companion;", "", "<init>", "()V", "NAME", "", "DEFAULT_REPLACE_OPTIONS", "Lcom/mongodb/client/model/ReplaceOptions;", "getDEFAULT_REPLACE_OPTIONS", "()Lcom/mongodb/client/model/ReplaceOptions;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReplaceOptions getDEFAULT_REPLACE_OPTIONS() {
            return DEFAULT_REPLACE_OPTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

