/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.openapi.AbstractRouteSpec;
import me.ahoo.wow.openapi.RouteSpec;
import me.ahoo.wow.openapi.Schemas;
import me.ahoo.wow.openapi.command.ErrorInfoSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030%2\u0014\b\u0002\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020/0.J\b\u00100\u001a\u00020\u0001H\u0016J2\u00101\u001a\u00020\t2\b\b\u0002\u0010)\u001a\u00020$2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030%2\u0014\b\u0002\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020/0.J\u0010\u0010-\u001a\u0002022\u0006\u00103\u001a\u000202H\u0016J\b\u00104\u001a\u00020/H\u0002J\b\u00105\u001a\u00020/H\u0002J(\u00106\u001a\u00020\t2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030%2\u0014\b\u0002\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020/0.J\b\u00107\u001a\u00020$H\u0016R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R$\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00068"}, d2={"Lme/ahoo/wow/openapi/AbstractRouteSpec;", "Lme/ahoo/wow/openapi/RouteSpec;", "()V", "errorCodeHeader", "Lio/swagger/v3/oas/models/headers/Header;", "kotlin.jvm.PlatformType", "getErrorCodeHeader", "()Lio/swagger/v3/oas/models/headers/Header;", "errorResponseContent", "Lio/swagger/v3/oas/models/media/Content;", "getErrorResponseContent", "()Lio/swagger/v3/oas/models/media/Content;", "isArrayResponse", "", "()Z", "parameters", "", "Lio/swagger/v3/oas/models/parameters/Parameter;", "getParameters", "()Ljava/util/List;", "requestBody", "Lio/swagger/v3/oas/models/parameters/RequestBody;", "getRequestBody", "()Lio/swagger/v3/oas/models/parameters/RequestBody;", "requestBodyType", "Ljava/lang/Class;", "getRequestBodyType", "()Ljava/lang/Class;", "responseType", "getResponseType", "responses", "Lio/swagger/v3/oas/models/responses/ApiResponses;", "getResponses", "()Lio/swagger/v3/oas/models/responses/ApiResponses;", "schemas", "", "", "Lio/swagger/v3/oas/models/media/Schema;", "getSchemas", "()Ljava/util/Map;", "addParameter", "name", "parameterIn", "Lio/swagger/v3/oas/annotations/enums/ParameterIn;", "schema", "customize", "Lkotlin/Function1;", "", "build", "context", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "apiResponse", "initResponse", "initSchema", "jsonContent", "toString", "wow-openapi"})
@SourceDebugExtension(value={"SMAP\nAbstractRouteSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRouteSpec.kt\nme/ahoo/wow/openapi/AbstractRouteSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1747#2,3:162\n*S KotlinDebug\n*F\n+ 1 AbstractRouteSpec.kt\nme/ahoo/wow/openapi/AbstractRouteSpec\n*L\n84#1:162,3\n*E\n"})
public abstract class AbstractRouteSpec
implements RouteSpec {
    @NotNull
    private final List<Parameter> parameters = new ArrayList();
    @NotNull
    private final Map<String, Schema<?>> schemas = new LinkedHashMap();
    @NotNull
    private final ApiResponses responses = new ApiResponses();
    private final Header errorCodeHeader = new Header().content(AbstractRouteSpec.context$default(this, null, (Schema)new StringSchema(), null, 5, null)).description("Error Code");
    @NotNull
    private final Content errorResponseContent = AbstractRouteSpec.jsonContent$default(this, ErrorInfoSchema.INSTANCE.getSchemaRef(), null, 2, null);

    @Nullable
    public Class<?> getRequestBodyType() {
        return null;
    }

    @Nullable
    public Class<?> getResponseType() {
        return null;
    }

    public boolean isArrayResponse() {
        return false;
    }

    @Override
    @NotNull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public Map<String, Schema<?>> getSchemas() {
        return this.schemas;
    }

    @Override
    @Nullable
    public RequestBody getRequestBody() {
        if (this.getRequestBodyType() == null) {
            return null;
        }
        Class<?> clazz = this.getRequestBodyType();
        Intrinsics.checkNotNull(clazz);
        Schema<?> schema = Schemas.INSTANCE.asSchemaRef(clazz);
        return new RequestBody().required(Boolean.valueOf(true)).content(AbstractRouteSpec.jsonContent$default(this, schema, null, 2, null));
    }

    @Override
    @NotNull
    public ApiResponses getResponses() {
        return this.responses;
    }

    protected final Header getErrorCodeHeader() {
        return this.errorCodeHeader;
    }

    @NotNull
    protected Content getErrorResponseContent() {
        return this.errorResponseContent;
    }

    @NotNull
    public final Content jsonContent(@NotNull Schema<?> schema, @NotNull Function1<? super Content, Unit> customize) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Intrinsics.checkNotNullParameter(customize, (String)"customize");
        return this.context("application/json", schema, customize);
    }

    public static /* synthetic */ Content jsonContent$default(AbstractRouteSpec abstractRouteSpec, Schema schema, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: jsonContent");
        }
        if ((n & 2) != 0) {
            function1 = jsonContent.1.INSTANCE;
        }
        return abstractRouteSpec.jsonContent(schema, (Function1<? super Content, Unit>)function1);
    }

    @NotNull
    public final Content context(@NotNull String name, @NotNull Schema<?> schema, @NotNull Function1<? super Content, Unit> customize) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Intrinsics.checkNotNullParameter(customize, (String)"customize");
        Content content = new Content().addMediaType(name, new MediaType().schema(schema));
        Intrinsics.checkNotNull((Object)content);
        customize.invoke((Object)content);
        return content;
    }

    public static /* synthetic */ Content context$default(AbstractRouteSpec abstractRouteSpec, String string, Schema schema, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: context");
        }
        if ((n & 1) != 0) {
            string = "*";
        }
        if ((n & 4) != 0) {
            function1 = context.1.INSTANCE;
        }
        return abstractRouteSpec.context(string, schema, (Function1<? super Content, Unit>)function1);
    }

    @Nullable
    public final Parameter addParameter(@NotNull String name, @NotNull ParameterIn parameterIn, @NotNull Schema<?> schema, @NotNull Function1<? super Parameter, Unit> customize) {
        boolean $this$any$iv2;
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)parameterIn, (String)"parameterIn");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter(customize, (String)"customize");
            Iterable $this$any$iv2 = this.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv2) {
                    Parameter it = (Parameter)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && Intrinsics.areEqual((Object)it.getIn(), (Object)parameterIn.toString()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean $this$addParameter_u24lambda_u241 = $this$any$iv2 = bl;
        boolean bl3 = false;
        if ($this$addParameter_u24lambda_u241) {
            return null;
        }
        Parameter parameter = new Parameter().name(name).in(parameterIn.toString()).schema(schema);
        Intrinsics.checkNotNull((Object)parameter);
        customize.invoke((Object)parameter);
        this.getParameters().add(parameter);
        return parameter;
    }

    public static /* synthetic */ Parameter addParameter$default(AbstractRouteSpec abstractRouteSpec, String string, ParameterIn parameterIn, Schema schema, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addParameter");
        }
        if ((n & 8) != 0) {
            function1 = addParameter.1.INSTANCE;
        }
        return abstractRouteSpec.addParameter(string, parameterIn, schema, (Function1<? super Parameter, Unit>)function1);
    }

    @Override
    @NotNull
    public RouteSpec build() {
        this.initSchema();
        this.initResponse();
        return this;
    }

    @NotNull
    public ApiResponse customize(@NotNull ApiResponse apiResponse) {
        Intrinsics.checkNotNullParameter((Object)apiResponse, (String)"apiResponse");
        return apiResponse;
    }

    private final void initResponse() {
        ApiResponse succeededResponse = new ApiResponse().addHeaderObject("Wow-Error-Code", this.errorCodeHeader).description("Ok");
        if (this.getResponseType() != null) {
            Class<?> clazz = this.getResponseType();
            Intrinsics.checkNotNull(clazz);
            if (!clazz.isPrimitive()) {
                Class<?> clazz2 = this.getResponseType();
                Intrinsics.checkNotNull(clazz2);
                Schema responseSchema = Schemas.INSTANCE.asSchemaRef(clazz2);
                Schema schema = this.isArrayResponse() ? (Schema)new ArraySchema().items(responseSchema) : responseSchema;
                Intrinsics.checkNotNull((Object)schema);
                succeededResponse.content(AbstractRouteSpec.jsonContent$default(this, schema, null, 2, null));
            }
        }
        Intrinsics.checkNotNull((Object)succeededResponse);
        this.customize(succeededResponse);
        this.getResponses().addApiResponse("200", succeededResponse);
        ApiResponse it = new ApiResponse().addHeaderObject("Wow-Error-Code", this.errorCodeHeader).description("Bad Request").content(this.getErrorResponseContent());
        boolean bl = false;
        this.getResponses().addApiResponse("400", it);
        it = new ApiResponse().addHeaderObject("Wow-Error-Code", this.errorCodeHeader).description("Not Found").content(this.getErrorResponseContent());
        boolean bl2 = false;
        this.getResponses().addApiResponse("404", it);
        it = new ApiResponse().addHeaderObject("Wow-Error-Code", this.errorCodeHeader).description("Request Timeout").content(this.getErrorResponseContent());
        boolean bl3 = false;
        this.getResponses().addApiResponse("408", it);
        it = new ApiResponse().addHeaderObject("Wow-Error-Code", this.errorCodeHeader).description("Too Many Requests").content(this.getErrorResponseContent());
        boolean bl4 = false;
        this.getResponses().addApiResponse("429", it);
    }

    private final void initSchema() {
        Object object = new Class[]{this.getRequestBodyType(), this.getResponseType()};
        Object $this$initSchema_u24lambda_u246 = object = Schemas.INSTANCE.asSchemas(CollectionsKt.listOf((Object[])object));
        boolean bl = false;
        this.getSchemas().putAll((Map<String, Schema<?>>)$this$initSchema_u24lambda_u246);
    }

    @NotNull
    public String toString() {
        return this.getId() + "@(" + this.getPath() + " && " + this.getMethod() + ")";
    }
}

