/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.openapi.event.state

import me.ahoo.wow.api.naming.NamedBoundedContext
import me.ahoo.wow.modeling.matedata.AggregateMetadata
import me.ahoo.wow.openapi.event.EventCompensateRouteSpec
import me.ahoo.wow.openapi.event.EventCompensateRouteSpecFactory

class StateEventCompensateRouteSpec(
    currentContext: NamedBoundedContext,
    aggregateMetadata: AggregateMetadata<*, *>,
) : EventCompensateRouteSpec(currentContext, aggregateMetadata) {

    override val topicKind: String
        get() = "state"
}

class StateEventCompensateRouteSpecFactory : EventCompensateRouteSpecFactory() {
    override fun create(
        currentContext: NamedBoundedContext,
        aggregateMetadata: AggregateMetadata<*, *>
    ): List<StateEventCompensateRouteSpec> {
        return listOf(StateEventCompensateRouteSpec(currentContext, aggregateMetadata))
    }
}
