/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.exception.ErrorInfo;
import me.ahoo.wow.openapi.ComponentRef;
import me.ahoo.wow.openapi.ComponentRefKt;
import me.ahoo.wow.openapi.HeaderRef;
import me.ahoo.wow.openapi.SchemaRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/openapi/ResponseRef;", "Lme/ahoo/wow/openapi/ComponentRef;", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "name", "", "component", "code", "<init>", "(Ljava/lang/String;Lio/swagger/v3/oas/models/responses/ApiResponse;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getComponent", "()Lio/swagger/v3/oas/models/responses/ApiResponse;", "getCode", "ref", "getRef", "Companion", "wow-openapi"})
public final class ResponseRef
implements ComponentRef<ApiResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final ApiResponse component;
    @NotNull
    private final String code;
    @NotNull
    private final ApiResponse ref;
    @NotNull
    private static final String COMPONENTS_RESPONSES_REF = "#/components/responses/";
    @NotNull
    private static final Content ERROR_INFO_CONTENT = ComponentRefKt.toJsonContent$default(SchemaRef.Companion.toRefSchema(ErrorInfo.class), null, 1, null);
    @NotNull
    private static final ResponseRef BAD_REQUEST = new ResponseRef("wow.BadRequest", Companion.toResponse(ERROR_INFO_CONTENT, "Bad Request"), "400");
    @NotNull
    private static final ResponseRef NOT_FOUND = new ResponseRef("wow.NotFound", Companion.toResponse(ERROR_INFO_CONTENT, "Not Found"), "404");
    @NotNull
    private static final ResponseRef REQUEST_TIMEOUT = new ResponseRef("wow.RequestTimeout", Companion.toResponse(ERROR_INFO_CONTENT, "Request Timeout"), "408");
    @NotNull
    private static final ResponseRef TOO_MANY_REQUESTS = new ResponseRef("wow.TooManyRequests", Companion.toResponse(ERROR_INFO_CONTENT, "Too Many Requests"), "429");

    public ResponseRef(@NotNull String name, @NotNull ApiResponse component, @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.name = name;
        this.component = component;
        this.code = code;
        this.ref = Companion.toRefResponse(this.getName());
    }

    public /* synthetic */ ResponseRef(String string, ApiResponse apiResponse, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "200";
        }
        this(string, apiResponse, string2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ApiResponse getComponent() {
        return this.component;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public ApiResponse getRef() {
        return this.ref;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u00020\t*\u00020\u0005J\u0014\u0010\u000e\u001a\u00020\t*\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0005J\"\u0010\u000e\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005J\"\u0010\u000e\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u000f\u001a\u00020\u0005J*\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 *\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 2\u0006\u0010!\u001a\u00020\u0016J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 *\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 *\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 J\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 *\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 *\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0 J\u0012\u0010\u001f\u001a\u00020&*\u00020&2\u0006\u0010!\u001a\u00020\u0016J\n\u0010\"\u001a\u00020&*\u00020&J\n\u0010#\u001a\u00020&*\u00020&J\n\u0010$\u001a\u00020&*\u00020&J\n\u0010%\u001a\u00020&*\u00020&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006'"}, d2={"Lme/ahoo/wow/openapi/ResponseRef$Companion;", "", "<init>", "()V", "COMPONENTS_RESPONSES_REF", "", "getCOMPONENTS_RESPONSES_REF", "()Ljava/lang/String;", "toRefResponse", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "ERROR_INFO_CONTENT", "Lio/swagger/v3/oas/models/media/Content;", "getERROR_INFO_CONTENT", "()Lio/swagger/v3/oas/models/media/Content;", "toResponse", "description", "Lio/swagger/v3/oas/models/media/Schema;", "mediaType", "Ljava/lang/Class;", "isArray", "", "BAD_REQUEST", "Lme/ahoo/wow/openapi/ResponseRef;", "getBAD_REQUEST", "()Lme/ahoo/wow/openapi/ResponseRef;", "NOT_FOUND", "getNOT_FOUND", "REQUEST_TIMEOUT", "getREQUEST_TIMEOUT", "TOO_MANY_REQUESTS", "getTOO_MANY_REQUESTS", "with", "", "responseRef", "withBadRequest", "withNotFound", "withRequestTimeout", "withTooManyRequests", "Lio/swagger/v3/oas/models/responses/ApiResponses;", "wow-openapi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCOMPONENTS_RESPONSES_REF() {
            return COMPONENTS_RESPONSES_REF;
        }

        @NotNull
        public final ApiResponse toRefResponse(@NotNull String $this$toRefResponse) {
            Intrinsics.checkNotNullParameter((Object)$this$toRefResponse, (String)"<this>");
            ApiResponse apiResponse = new ApiResponse().$ref(this.getCOMPONENTS_RESPONSES_REF() + $this$toRefResponse);
            Intrinsics.checkNotNullExpressionValue((Object)apiResponse, (String)"$ref(...)");
            return apiResponse;
        }

        @NotNull
        public final Content getERROR_INFO_CONTENT() {
            return ERROR_INFO_CONTENT;
        }

        @NotNull
        public final ApiResponse toResponse(@NotNull Content $this$toResponse, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)$this$toResponse, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            ApiResponse apiResponse = new ApiResponse().addHeaderObject("Wow-Error-Code", HeaderRef.Companion.getERROR_CODE_HEADER().getRef()).description(description).content($this$toResponse);
            Intrinsics.checkNotNullExpressionValue((Object)apiResponse, (String)"content(...)");
            return apiResponse;
        }

        public static /* synthetic */ ApiResponse toResponse$default(Companion companion, Content content, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "Ok";
            }
            return companion.toResponse(content, string);
        }

        @NotNull
        public final ApiResponse toResponse(@NotNull Schema<?> $this$toResponse, @NotNull String mediaType, @NotNull String description) {
            Intrinsics.checkNotNullParameter($this$toResponse, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return this.toResponse(ComponentRefKt.toContent$default($this$toResponse, mediaType, null, 2, null), description);
        }

        public static /* synthetic */ ApiResponse toResponse$default(Companion companion, Schema schema, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "application/json";
            }
            if ((n & 2) != 0) {
                string2 = "Ok";
            }
            return companion.toResponse(schema, string, string2);
        }

        @NotNull
        public final ApiResponse toResponse(@NotNull Class<?> $this$toResponse, boolean isArray, @NotNull String description) {
            Intrinsics.checkNotNullParameter($this$toResponse, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Schema responseSchema = SchemaRef.Companion.toRefSchema($this$toResponse);
            return me.ahoo.wow.openapi.ResponseRef$Companion.toResponse$default(this, isArray ? (Schema)SchemaRef.Companion.toArraySchema(responseSchema) : responseSchema, null, description, 1, null);
        }

        public static /* synthetic */ ApiResponse toResponse$default(Companion companion, Class clazz, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                string = "Ok";
            }
            return companion.toResponse(clazz, bl, string);
        }

        @NotNull
        public final ResponseRef getBAD_REQUEST() {
            return BAD_REQUEST;
        }

        @NotNull
        public final ResponseRef getNOT_FOUND() {
            return NOT_FOUND;
        }

        @NotNull
        public final ResponseRef getREQUEST_TIMEOUT() {
            return REQUEST_TIMEOUT;
        }

        @NotNull
        public final ResponseRef getTOO_MANY_REQUESTS() {
            return TOO_MANY_REQUESTS;
        }

        @NotNull
        public final Map<String, ApiResponse> with(@NotNull Map<String, ApiResponse> $this$with, @NotNull ResponseRef responseRef) {
            Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)responseRef, (String)"responseRef");
            $this$with.put(responseRef.getName(), responseRef.getComponent());
            return $this$with;
        }

        @NotNull
        public final Map<String, ApiResponse> withBadRequest(@NotNull Map<String, ApiResponse> $this$withBadRequest) {
            Intrinsics.checkNotNullParameter($this$withBadRequest, (String)"<this>");
            return this.with($this$withBadRequest, this.getBAD_REQUEST());
        }

        @NotNull
        public final Map<String, ApiResponse> withNotFound(@NotNull Map<String, ApiResponse> $this$withNotFound) {
            Intrinsics.checkNotNullParameter($this$withNotFound, (String)"<this>");
            return this.with($this$withNotFound, this.getNOT_FOUND());
        }

        @NotNull
        public final Map<String, ApiResponse> withRequestTimeout(@NotNull Map<String, ApiResponse> $this$withRequestTimeout) {
            Intrinsics.checkNotNullParameter($this$withRequestTimeout, (String)"<this>");
            return this.with($this$withRequestTimeout, this.getREQUEST_TIMEOUT());
        }

        @NotNull
        public final Map<String, ApiResponse> withTooManyRequests(@NotNull Map<String, ApiResponse> $this$withTooManyRequests) {
            Intrinsics.checkNotNullParameter($this$withTooManyRequests, (String)"<this>");
            return this.with($this$withTooManyRequests, this.getTOO_MANY_REQUESTS());
        }

        @NotNull
        public final ApiResponses with(@NotNull ApiResponses $this$with, @NotNull ResponseRef responseRef) {
            Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)responseRef, (String)"responseRef");
            ApiResponses apiResponses = $this$with.addApiResponse(responseRef.getCode(), responseRef.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)apiResponses, (String)"addApiResponse(...)");
            return apiResponses;
        }

        @NotNull
        public final ApiResponses withBadRequest(@NotNull ApiResponses $this$withBadRequest) {
            Intrinsics.checkNotNullParameter((Object)$this$withBadRequest, (String)"<this>");
            return this.with($this$withBadRequest, this.getBAD_REQUEST());
        }

        @NotNull
        public final ApiResponses withNotFound(@NotNull ApiResponses $this$withNotFound) {
            Intrinsics.checkNotNullParameter((Object)$this$withNotFound, (String)"<this>");
            return this.with($this$withNotFound, this.getNOT_FOUND());
        }

        @NotNull
        public final ApiResponses withRequestTimeout(@NotNull ApiResponses $this$withRequestTimeout) {
            Intrinsics.checkNotNullParameter((Object)$this$withRequestTimeout, (String)"<this>");
            return this.with($this$withRequestTimeout, this.getREQUEST_TIMEOUT());
        }

        @NotNull
        public final ApiResponses withTooManyRequests(@NotNull ApiResponses $this$withTooManyRequests) {
            Intrinsics.checkNotNullParameter((Object)$this$withTooManyRequests, (String)"<this>");
            return this.with($this$withTooManyRequests, this.getTOO_MANY_REQUESTS());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

