/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi.converter;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.event.DomainEvent;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.state.StateEvent;
import me.ahoo.wow.openapi.SchemaRef;
import me.ahoo.wow.openapi.converter.BoundedContextSchemaNameConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J,\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0016\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/openapi/converter/DomainEventConverter;", "Lio/swagger/v3/core/converter/ModelConverter;", "()V", "isDomainEvent", "", "type", "Lio/swagger/v3/core/converter/AnnotatedType;", "resolve", "Lio/swagger/v3/oas/models/media/Schema;", "context", "Lio/swagger/v3/core/converter/ModelConverterContext;", "chain", "", "Companion", "wow-openapi"})
public final class DomainEventConverter
implements ModelConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> wrapTypes;

    @Nullable
    public Schema<?> resolve(@NotNull AnnotatedType type, @NotNull ModelConverterContext context, @NotNull Iterator<? extends ModelConverter> chain) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        if (!chain.hasNext()) {
            return null;
        }
        boolean isDomainEvent = this.isDomainEvent(type);
        Object object = type.getParent();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        boolean isWrapped = wrapTypes.contains(object);
        if (isDomainEvent && isWrapped) {
            type.setName("wow.WrappedDomainEvent");
        }
        Schema schema = chain.next().resolve(type, context, chain);
        if (schema == null) {
            return null;
        }
        Schema resolvedSchema = schema;
        if (!isDomainEvent) {
            return resolvedSchema;
        }
        if (isWrapped && resolvedSchema.getProperties() != null) {
            Map map = resolvedSchema.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getProperties(...)");
            Map map2 = map;
            String string = "bodyType";
            StringSchema stringSchema = new StringSchema();
            map2.put(string, stringSchema);
            resolvedSchema.getProperties().remove("last");
            resolvedSchema.getProperties().remove("header");
            resolvedSchema.getProperties().remove("aggregateId");
            resolvedSchema.getProperties().remove("sequence");
            resolvedSchema.getProperties().remove("readOnly");
            resolvedSchema.getProperties().remove("createTime");
            resolvedSchema.getProperties().remove("contextName");
            resolvedSchema.getProperties().remove("commandId");
            resolvedSchema.getProperties().remove("aggregateName");
            resolvedSchema.getProperties().remove("version");
            resolvedSchema.getProperties().remove("initialVersion");
            resolvedSchema.getProperties().remove("initialized");
        }
        return resolvedSchema;
    }

    private final boolean isDomainEvent(AnnotatedType type) {
        Class<?> clazz = BoundedContextSchemaNameConverter.Companion.getRawClass(type);
        if (clazz == null) {
            return false;
        }
        Class<?> rawClass = clazz;
        return Intrinsics.areEqual(rawClass, DomainEvent.class);
    }

    static {
        Object[] objectArray = new String[2];
        Intrinsics.checkNotNull((Object)SchemaRef.Companion.toSchemaName(DomainEventStream.class));
        Intrinsics.checkNotNull((Object)SchemaRef.Companion.toSchemaName(StateEvent.class));
        wrapTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/openapi/converter/DomainEventConverter$Companion;", "", "()V", "wrapTypes", "", "", "wow-openapi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

