/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi.context;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.openapi.ApiResponseBuilder;
import me.ahoo.wow.openapi.RequestBodyBuilder;
import me.ahoo.wow.openapi.context.OpenAPIComponentContext;
import me.ahoo.wow.schema.openapi.InlineSchemaCapable;
import me.ahoo.wow.schema.openapi.OpenAPISchemaBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0!\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010\"J-\u0010#\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0!\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010$J-\u0010%\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0!\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010$J\f\u0010&\u001a\u00020'*\u00020\tH\u0002J\u001a\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010\tH\u0002J)\u0010+\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\t2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0016J)\u0010/\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\t2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0016J)\u00100\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\t2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0016J)\u00102\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\t2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0016J\b\u00104\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0012\u00105\u001a\u000206X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Lme/ahoo/wow/openapi/context/DefaultOpenAPIComponentContext;", "Lme/ahoo/wow/openapi/context/OpenAPIComponentContext;", "Lme/ahoo/wow/schema/openapi/InlineSchemaCapable;", "schemaBuilder", "Lme/ahoo/wow/schema/openapi/OpenAPISchemaBuilder;", "<init>", "(Lme/ahoo/wow/schema/openapi/OpenAPISchemaBuilder;)V", "schemas", "", "", "Lio/swagger/v3/oas/models/media/Schema;", "getSchemas", "()Ljava/util/Map;", "setSchemas", "(Ljava/util/Map;)V", "parameters", "", "Lio/swagger/v3/oas/models/parameters/Parameter;", "getParameters", "headers", "Lio/swagger/v3/oas/models/headers/Header;", "getHeaders", "requestBodies", "Lio/swagger/v3/oas/models/parameters/RequestBody;", "getRequestBodies", "responses", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "getResponses", "resolveType", "Lcom/fasterxml/classmate/ResolvedType;", "mainTargetType", "Ljava/lang/reflect/Type;", "typeParameters", "", "(Ljava/lang/reflect/Type;[Ljava/lang/reflect/Type;)Lcom/fasterxml/classmate/ResolvedType;", "arraySchema", "(Ljava/lang/reflect/Type;[Ljava/lang/reflect/Type;)Lio/swagger/v3/oas/models/media/Schema;", "schema", "requiredKeyNotBlank", "", "resolveKey", "key", "componentName", "parameter", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "header", "requestBody", "Lme/ahoo/wow/openapi/RequestBodyBuilder;", "response", "Lme/ahoo/wow/openapi/ApiResponseBuilder;", "finish", "inline", "", "getInline", "()Z", "wow-openapi"})
public final class DefaultOpenAPIComponentContext
implements OpenAPIComponentContext,
InlineSchemaCapable {
    @NotNull
    private final OpenAPISchemaBuilder schemaBuilder;
    @NotNull
    private Map<String, ? extends Schema<?>> schemas;
    @NotNull
    private final Map<String, Parameter> parameters;
    @NotNull
    private final Map<String, Header> headers;
    @NotNull
    private final Map<String, RequestBody> requestBodies;
    @NotNull
    private final Map<String, ApiResponse> responses;

    public DefaultOpenAPIComponentContext(@NotNull OpenAPISchemaBuilder schemaBuilder) {
        Intrinsics.checkNotNullParameter((Object)schemaBuilder, (String)"schemaBuilder");
        this.schemaBuilder = schemaBuilder;
        this.schemas = MapsKt.emptyMap();
        this.parameters = new LinkedHashMap();
        this.headers = new LinkedHashMap();
        this.requestBodies = new LinkedHashMap();
        this.responses = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Map<String, Schema<?>> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(@NotNull Map<String, ? extends Schema<?>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.schemas = map;
    }

    @Override
    @NotNull
    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public Map<String, RequestBody> getRequestBodies() {
        return this.requestBodies;
    }

    @Override
    @NotNull
    public Map<String, ApiResponse> getResponses() {
        return this.responses;
    }

    @Override
    @NotNull
    public ResolvedType resolveType(@NotNull Type mainTargetType, Type ... typeParameters) {
        Intrinsics.checkNotNullParameter((Object)mainTargetType, (String)"mainTargetType");
        Intrinsics.checkNotNullParameter((Object)typeParameters, (String)"typeParameters");
        return this.schemaBuilder.resolveType(mainTargetType, Arrays.copyOf(typeParameters, typeParameters.length));
    }

    @Override
    @NotNull
    public Schema<?> arraySchema(@NotNull Type mainTargetType, Type ... typeParameters) {
        Intrinsics.checkNotNullParameter((Object)mainTargetType, (String)"mainTargetType");
        Intrinsics.checkNotNullParameter((Object)typeParameters, (String)"typeParameters");
        Schema<?> it = this.schema(mainTargetType, Arrays.copyOf(typeParameters, typeParameters.length));
        boolean bl = false;
        ArraySchema arraySchema = new ArraySchema().items(it);
        Intrinsics.checkNotNullExpressionValue((Object)arraySchema, (String)"let(...)");
        return (Schema)arraySchema;
    }

    @Override
    @NotNull
    public Schema<?> schema(@NotNull Type mainTargetType, Type ... typeParameters) {
        Intrinsics.checkNotNullParameter((Object)mainTargetType, (String)"mainTargetType");
        Intrinsics.checkNotNullParameter((Object)typeParameters, (String)"typeParameters");
        return this.schemaBuilder.generateSchema(mainTargetType, Arrays.copyOf(typeParameters, typeParameters.length));
    }

    private final void requiredKeyNotBlank(String $this$requiredKeyNotBlank) {
        if (!(!StringsKt.isBlank((CharSequence)$this$requiredKeyNotBlank))) {
            boolean bl = false;
            String string = "key must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final String resolveKey(String key, String componentName) {
        if (!StringsKt.isBlank((CharSequence)key)) {
            return key;
        }
        String string = componentName;
        if (!(string != null ? !StringsKt.isBlank((CharSequence)string) : false)) {
            boolean bl = false;
            String string2 = "componentName must not be blank";
            throw new IllegalArgumentException(string2.toString());
        }
        return "wow." + componentName;
    }

    @Override
    @NotNull
    public Parameter parameter(@NotNull String key, @NotNull Function1<? super Parameter, Unit> builder) {
        Parameter parameter;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Parameter parameter2 = new Parameter();
        builder.invoke((Object)parameter2);
        Parameter parameter3 = parameter2;
        if (this.getInline()) {
            return parameter3;
        }
        String resolvedKey = this.resolveKey(key, parameter3.getName());
        this.getParameters().put(resolvedKey, parameter3);
        Parameter it = parameter = new Parameter();
        boolean bl = false;
        it.set$ref("#/components/parameters/" + resolvedKey);
        return parameter;
    }

    @Override
    @NotNull
    public Header header(@NotNull String key, @NotNull Function1<? super Header, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Header header = new Header();
        builder.invoke((Object)header);
        Header header2 = header;
        if (this.getInline()) {
            return header2;
        }
        this.requiredKeyNotBlank(key);
        this.getHeaders().put(key, header2);
        Header it = header = new Header();
        boolean bl = false;
        it.set$ref("#/components/headers/" + key);
        return header;
    }

    @Override
    @NotNull
    public RequestBody requestBody(@NotNull String key, @NotNull Function1<? super RequestBodyBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        RequestBodyBuilder requestBodyBuilder = new RequestBodyBuilder();
        builder.invoke((Object)requestBodyBuilder);
        RequestBody requestBody = requestBodyBuilder.build();
        if (this.getInline()) {
            return requestBody;
        }
        this.requiredKeyNotBlank(key);
        this.getRequestBodies().put(key, requestBody);
        RequestBodyBuilder it = requestBodyBuilder = new RequestBody();
        boolean bl = false;
        it.set$ref("#/components/requestBodies/" + key);
        return requestBodyBuilder;
    }

    @Override
    @NotNull
    public ApiResponse response(@NotNull String key, @NotNull Function1<? super ApiResponseBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        ApiResponseBuilder apiResponseBuilder = new ApiResponseBuilder();
        builder.invoke((Object)apiResponseBuilder);
        ApiResponse apiResponse = apiResponseBuilder.build();
        if (this.getInline()) {
            return apiResponse;
        }
        this.requiredKeyNotBlank(key);
        this.getResponses().put(key, apiResponse);
        ApiResponseBuilder it = apiResponseBuilder = new ApiResponse();
        boolean bl = false;
        it.set$ref("#/components/responses/" + key);
        return apiResponseBuilder;
    }

    @Override
    public void finish() {
        this.setSchemas(this.schemaBuilder.build());
    }

    public boolean getInline() {
        return this.schemaBuilder.getInline();
    }
}

