/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi.converter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.naming.CurrentBoundedContext;
import me.ahoo.wow.schema.JavaTypeResolver;
import me.ahoo.wow.schema.Types;
import me.ahoo.wow.schema.naming.WowSchemaNamingStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/openapi/converter/BoundedContextSchemaNameConverter;", "Lio/swagger/v3/core/converter/ModelConverter;", "<init>", "()V", "resolve", "Lio/swagger/v3/oas/models/media/Schema;", "type", "Lio/swagger/v3/core/converter/AnnotatedType;", "context", "Lio/swagger/v3/core/converter/ModelConverterContext;", "chain", "", "Companion", "wow-openapi"})
public final class BoundedContextSchemaNameConverter
implements ModelConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Schema<?> resolve(@NotNull AnnotatedType type, @NotNull ModelConverterContext context, @NotNull Iterator<? extends ModelConverter> chain) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Companion.resolveName(type);
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/openapi/converter/BoundedContextSchemaNameConverter$Companion;", "", "<init>", "()V", "resolveName", "", "Lio/swagger/v3/core/converter/AnnotatedType;", "rawClass", "Ljava/lang/Class;", "javaType", "Lcom/fasterxml/jackson/databind/JavaType;", "resolvedType", "Lcom/fasterxml/classmate/ResolvedType;", "wow-openapi"})
    public static final class Companion {
        private Companion() {
        }

        public final void resolveName(@NotNull AnnotatedType $this$resolveName, @NotNull Class<?> rawClass) {
            Intrinsics.checkNotNullParameter((Object)$this$resolveName, (String)"<this>");
            Intrinsics.checkNotNullParameter(rawClass, (String)"rawClass");
            CharSequence charSequence = $this$resolveName.getName();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return;
            }
            if (Types.INSTANCE.isStdType(rawClass)) {
                return;
            }
            String string = WowSchemaNamingStrategy.Companion.resolveNamePrefix(rawClass);
            if (string == null) {
                string = MaterializedNamedAggregateKt.getContextAliasPrefix((NamedBoundedContext)CurrentBoundedContext.INSTANCE.getCurrent());
            }
            String namePrefix = string;
            $this$resolveName.setName(namePrefix + WowSchemaNamingStrategy.Companion.toSchemaName(rawClass));
        }

        public final void resolveName(@NotNull AnnotatedType $this$resolveName, @NotNull JavaType javaType) {
            Intrinsics.checkNotNullParameter((Object)$this$resolveName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)javaType, (String)"javaType");
            ResolvedType resolvedType = JavaTypeResolver.toResolvedType$default((JavaTypeResolver)JavaTypeResolver.INSTANCE, (JavaType)javaType, null, (int)1, null);
            this.resolveName($this$resolveName, resolvedType);
        }

        public final void resolveName(@NotNull AnnotatedType $this$resolveName, @NotNull ResolvedType resolvedType) {
            Intrinsics.checkNotNullParameter((Object)$this$resolveName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)resolvedType, (String)"resolvedType");
            if (!resolvedType.isArray() && resolvedType.getTypeBindings().isEmpty()) {
                Class clazz = resolvedType.getErasedType();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getErasedType(...)");
                this.resolveName($this$resolveName, clazz);
                return;
            }
            $this$resolveName.setName(WowSchemaNamingStrategy.Companion.toSchemaName(resolvedType, MaterializedNamedAggregateKt.getContextAliasPrefix((NamedBoundedContext)CurrentBoundedContext.INSTANCE.getCurrent())));
        }

        public final void resolveName(@NotNull AnnotatedType $this$resolveName) {
            Type schemaType;
            Intrinsics.checkNotNullParameter((Object)$this$resolveName, (String)"<this>");
            Type type = schemaType = $this$resolveName.getType();
            if (type instanceof Class) {
                this.resolveName($this$resolveName, (Class)schemaType);
            } else if (type instanceof JavaType) {
                this.resolveName($this$resolveName, (JavaType)schemaType);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

