/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi.converter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.openapi.context.CurrentOpenAPIComponentContext;
import me.ahoo.wow.openapi.context.OpenAPIComponentContext;
import me.ahoo.wow.openapi.converter.BoundedContextSchemaNameConverter;
import me.ahoo.wow.schema.JavaTypeResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/openapi/converter/WowSchemaConverter;", "Lio/swagger/v3/core/converter/ModelConverter;", "<init>", "()V", "resolve", "Lio/swagger/v3/oas/models/media/Schema;", "type", "Lio/swagger/v3/core/converter/AnnotatedType;", "context", "Lio/swagger/v3/core/converter/ModelConverterContext;", "chain", "", "resolveSchema", "annotatedType", "wow-openapi"})
public final class WowSchemaConverter
implements ModelConverter {
    @Nullable
    public Schema<?> resolve(@NotNull AnnotatedType type, @NotNull ModelConverterContext context, @NotNull Iterator<? extends ModelConverter> chain) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Schema<?> it = this.resolveSchema(type);
        boolean bl = false;
        if (it != null) {
            return it;
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    private final Schema<?> resolveSchema(AnnotatedType annotatedType) {
        OpenAPIComponentContext openAPIComponentContext = CurrentOpenAPIComponentContext.INSTANCE.getCurrent();
        if (openAPIComponentContext == null) {
            return null;
        }
        OpenAPIComponentContext current = openAPIComponentContext;
        Type schemaType = annotatedType.getType();
        Schema<?> schema = null;
        Type type = schemaType;
        if (type instanceof Class) {
            BoundedContextSchemaNameConverter.Companion.resolveName(annotatedType, (Class)schemaType);
            schema = current.schema(schemaType, new Type[0]);
        } else if (type instanceof JavaType) {
            ResolvedType resolvedType = JavaTypeResolver.toResolvedType$default((JavaTypeResolver)JavaTypeResolver.INSTANCE, (JavaType)((JavaType)schemaType), null, (int)1, null);
            BoundedContextSchemaNameConverter.Companion.resolveName(annotatedType, resolvedType);
            schema = current.schema((Type)resolvedType, new Type[0]);
        }
        if (schema != null) {
            schema.setName(annotatedType.getName());
        }
        return schema;
    }
}

