/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.openapi.converter;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.openapi.SchemaRef;
import me.ahoo.wow.serialization.JsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/openapi/converter/BoundedContextSchemaNameConverter;", "Lio/swagger/v3/core/converter/ModelConverter;", "<init>", "()V", "resolve", "Lio/swagger/v3/oas/models/media/Schema;", "type", "Lio/swagger/v3/core/converter/AnnotatedType;", "context", "Lio/swagger/v3/core/converter/ModelConverterContext;", "chain", "", "resolveName", "", "Companion", "wow-openapi"})
public final class BoundedContextSchemaNameConverter
implements ModelConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String STD_LIB_PREFIX = "java.";

    @Nullable
    public Schema<?> resolve(@NotNull AnnotatedType type, @NotNull ModelConverterContext context, @NotNull Iterator<? extends ModelConverter> chain) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        this.resolveName(type);
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    private final void resolveName(AnnotatedType type) {
        CharSequence charSequence = type.getName();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return;
        }
        Class<?> clazz = Companion.getRawClass(type);
        if (clazz == null) {
            return;
        }
        Class<?> rawClass = clazz;
        String string = rawClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)STD_LIB_PREFIX, (boolean)false, (int)2, null)) {
            return;
        }
        type.setName(SchemaRef.Companion.toSchemaName(rawClass));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u00020\bJ\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/openapi/converter/BoundedContextSchemaNameConverter$Companion;", "", "<init>", "()V", "STD_LIB_PREFIX", "", "getRawClass", "Ljava/lang/Class;", "Lio/swagger/v3/core/converter/AnnotatedType;", "getJavaType", "Lcom/fasterxml/jackson/databind/JavaType;", "wow-openapi"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Class<?> getRawClass(@NotNull AnnotatedType $this$getRawClass) {
            Intrinsics.checkNotNullParameter((Object)$this$getRawClass, (String)"<this>");
            Type schemaType = $this$getRawClass.getType();
            if (schemaType instanceof Class) {
                return (Class)schemaType;
            }
            if (schemaType instanceof JavaType) {
                return ((JavaType)schemaType).getRawClass();
            }
            return null;
        }

        @Nullable
        public final JavaType getJavaType(@NotNull AnnotatedType $this$getJavaType) {
            Intrinsics.checkNotNullParameter((Object)$this$getJavaType, (String)"<this>");
            Type schemaType = $this$getJavaType.getType();
            if (schemaType instanceof JavaType) {
                return (JavaType)schemaType;
            }
            if (schemaType instanceof Class) {
                return JsonSerializer.INSTANCE.constructType(schemaType);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

