/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry.messaging;

import io.opentelemetry.context.Context;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.LocalCommandBus;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.SimpleServerCommandExchange;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.opentelemetry.messaging.LocalCommandBusInstrumenter;
import me.ahoo.wow.opentelemetry.messaging.MonoLocalBusTrace;
import me.ahoo.wow.opentelemetry.messaging.TracingMessageBus;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/opentelemetry/messaging/TracingLocalCommandBus;", "Lme/ahoo/wow/opentelemetry/messaging/TracingMessageBus;", "Lme/ahoo/wow/command/LocalCommandBus;", "delegate", "(Lme/ahoo/wow/command/LocalCommandBus;)V", "getDelegate", "()Lme/ahoo/wow/command/LocalCommandBus;", "close", "", "receive", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/ServerCommandExchange;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "Lme/ahoo/wow/api/command/CommandMessage;", "sendExchange", "exchange", "wow-opentelemetry"})
public final class TracingLocalCommandBus
implements TracingMessageBus<LocalCommandBus>,
LocalCommandBus {
    @NotNull
    private final LocalCommandBus delegate;

    public TracingLocalCommandBus(@NotNull LocalCommandBus delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    public LocalCommandBus getDelegate() {
        return this.delegate;
    }

    @NotNull
    public Mono<Void> send(@NotNull CommandMessage<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        SimpleServerCommandExchange exchange = new SimpleServerCommandExchange(message, null, null, null, 14, null);
        return this.sendExchange((ServerCommandExchange)exchange);
    }

    @NotNull
    public Flux<ServerCommandExchange<?>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.getDelegate().receive(namedAggregates);
    }

    @NotNull
    public Mono<Void> sendExchange(@NotNull ServerCommandExchange<?> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Mono source = this.getDelegate().sendExchange((MessageExchange)exchange);
        Context parentContext = Context.current();
        Intrinsics.checkNotNullExpressionValue((Object)parentContext, (String)"parentContext");
        return new MonoLocalBusTrace<MessageExchange>(parentContext, LocalCommandBusInstrumenter.INSTANCE.getINSTRUMENTER(), (MessageExchange)exchange, (Mono<Void>)source);
    }

    public void close() {
        this.getDelegate().close();
    }
}

