/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry.messaging;

import io.opentelemetry.context.Context;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.EventStreamExchange;
import me.ahoo.wow.event.LocalDomainEventBus;
import me.ahoo.wow.event.SimpleEventStreamExchange;
import me.ahoo.wow.infra.Decorator;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.opentelemetry.messaging.LocalEventBusInstrumenter;
import me.ahoo.wow.opentelemetry.messaging.MonoLocalBusTrace;
import me.ahoo.wow.opentelemetry.messaging.TracingMessageBus;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/opentelemetry/messaging/TracingLocalEventBus;", "Lme/ahoo/wow/opentelemetry/messaging/TracingMessageBus;", "Lme/ahoo/wow/event/LocalDomainEventBus;", "Lme/ahoo/wow/infra/Decorator;", "delegate", "(Lme/ahoo/wow/event/LocalDomainEventBus;)V", "getDelegate", "()Lme/ahoo/wow/event/LocalDomainEventBus;", "close", "", "receive", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/event/EventStreamExchange;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "Lme/ahoo/wow/event/DomainEventStream;", "sendExchange", "exchange", "wow-opentelemetry"})
public final class TracingLocalEventBus
implements TracingMessageBus<LocalDomainEventBus>,
LocalDomainEventBus,
Decorator<LocalDomainEventBus> {
    @NotNull
    private final LocalDomainEventBus delegate;

    public TracingLocalEventBus(@NotNull LocalDomainEventBus delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    public LocalDomainEventBus getDelegate() {
        return this.delegate;
    }

    @NotNull
    public Mono<Void> send(@NotNull DomainEventStream message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SimpleEventStreamExchange exchange = new SimpleEventStreamExchange(message, null, 2, null);
        return this.sendExchange((EventStreamExchange)exchange);
    }

    @NotNull
    public Flux<EventStreamExchange> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.getDelegate().receive(namedAggregates);
    }

    @NotNull
    public Mono<Void> sendExchange(@NotNull EventStreamExchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Mono source = this.getDelegate().sendExchange((MessageExchange)exchange);
        Context parentContext = Context.current();
        Intrinsics.checkNotNullExpressionValue((Object)parentContext, (String)"parentContext");
        return new MonoLocalBusTrace<MessageExchange>(parentContext, LocalEventBusInstrumenter.INSTANCE.getINSTRUMENTER(), (MessageExchange)exchange, (Mono<Void>)source);
    }

    public void close() {
        this.getDelegate().close();
    }
}

