/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.messaging.handler.MessageExchange;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B9\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\u0007H\u0014J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0016\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/opentelemetry/TraceFilterSubscriber;", "T", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "Lreactor/core/publisher/BaseSubscriber;", "Ljava/lang/Void;", "instrumenter", "Lio/opentelemetry/instrumentation/api/instrumenter/Instrumenter;", "", "otelContext", "Lio/opentelemetry/context/Context;", "exchange", "actual", "Lreactor/core/CoreSubscriber;", "(Lio/opentelemetry/instrumentation/api/instrumenter/Instrumenter;Lio/opentelemetry/context/Context;Lme/ahoo/wow/messaging/handler/MessageExchange;Lreactor/core/CoreSubscriber;)V", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "currentContext", "Lreactor/util/context/Context;", "hookOnCancel", "hookOnComplete", "hookOnError", "throwable", "", "hookOnSubscribe", "subscription", "Lorg/reactivestreams/Subscription;", "wow-opentelemetry"})
public final class TraceFilterSubscriber<T extends MessageExchange<?>>
extends BaseSubscriber<Void> {
    @NotNull
    private final Instrumenter<T, Unit> instrumenter;
    @NotNull
    private final Context otelContext;
    @NotNull
    private final T exchange;
    @NotNull
    private final CoreSubscriber<? super Void> actual;

    public TraceFilterSubscriber(@NotNull Instrumenter<T, Unit> instrumenter, @NotNull Context otelContext, @NotNull T exchange, @NotNull CoreSubscriber<? super Void> actual) {
        Intrinsics.checkNotNullParameter(instrumenter, (String)"instrumenter");
        Intrinsics.checkNotNullParameter((Object)otelContext, (String)"otelContext");
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        this.instrumenter = instrumenter;
        this.otelContext = otelContext;
        this.exchange = exchange;
        this.actual = actual;
    }

    @NotNull
    public reactor.util.context.Context currentContext() {
        reactor.util.context.Context context = this.actual.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"actual.currentContext()");
        return context;
    }

    protected void hookOnSubscribe(@NotNull Subscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        this.actual.onSubscribe((Subscription)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hookOnError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        try {
            AutoCloseable autoCloseable = (AutoCloseable)this.otelContext.makeCurrent();
            Throwable throwable2 = null;
            try {
                Scope it = (Scope)autoCloseable;
                boolean bl = false;
                this.actual.onError(throwable);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
        }
        finally {
            this.instrumenter.end(this.otelContext, this.exchange, null, throwable);
        }
    }

    protected void hookOnCancel() {
        this.instrumenter.end(this.otelContext, this.exchange, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hookOnComplete() {
        try {
            AutoCloseable autoCloseable = (AutoCloseable)this.otelContext.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it = (Scope)autoCloseable;
                boolean bl = false;
                this.actual.onComplete();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        finally {
            this.instrumenter.end(this.otelContext, this.exchange, null, null);
        }
    }
}

