/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry.messaging;

import io.opentelemetry.context.Context;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.EventStreamExchange;
import me.ahoo.wow.event.SimpleEventStreamExchange;
import me.ahoo.wow.infra.Decorator;
import me.ahoo.wow.messaging.LocalSendMessageBus;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.opentelemetry.messaging.LocalEventBusInstrumenter;
import me.ahoo.wow.opentelemetry.messaging.MonoLocalBusTrace;
import me.ahoo.wow.opentelemetry.messaging.TracingMessageBus;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/opentelemetry/messaging/TracingLocalEventBus;", "Lme/ahoo/wow/opentelemetry/messaging/TracingMessageBus;", "Lme/ahoo/wow/event/DomainEventBus;", "Lme/ahoo/wow/infra/Decorator;", "delegate", "(Lme/ahoo/wow/event/DomainEventBus;)V", "getDelegate", "()Lme/ahoo/wow/event/DomainEventBus;", "localSendMessageBus", "Lme/ahoo/wow/messaging/LocalSendMessageBus;", "Lme/ahoo/wow/event/DomainEventStream;", "Lme/ahoo/wow/event/EventStreamExchange;", "receive", "Lreactor/core/publisher/Flux;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "wow-opentelemetry"})
public final class TracingLocalEventBus
implements TracingMessageBus<DomainEventBus>,
DomainEventBus,
Decorator<DomainEventBus> {
    @NotNull
    private final DomainEventBus delegate;
    @NotNull
    private final LocalSendMessageBus<DomainEventStream, EventStreamExchange> localSendMessageBus;

    public TracingLocalEventBus(@NotNull DomainEventBus delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        if (!(this.getDelegate() instanceof LocalSendMessageBus)) {
            boolean bl = false;
            String string = "delegate must be LocalSendMessageBus.";
            throw new IllegalArgumentException(string.toString());
        }
        DomainEventBus domainEventBus = this.getDelegate();
        Intrinsics.checkNotNull((Object)domainEventBus, (String)"null cannot be cast to non-null type me.ahoo.wow.messaging.LocalSendMessageBus<me.ahoo.wow.event.DomainEventStream, me.ahoo.wow.event.EventStreamExchange>");
        this.localSendMessageBus = (LocalSendMessageBus)domainEventBus;
    }

    @NotNull
    public DomainEventBus getDelegate() {
        return this.delegate;
    }

    @NotNull
    public Mono<Void> send(@NotNull DomainEventStream message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SimpleEventStreamExchange exchange = new SimpleEventStreamExchange(message, null, null, 6, null);
        Mono source = this.localSendMessageBus.sendExchange((MessageExchange)exchange);
        Context parentContext = Context.current();
        Intrinsics.checkNotNullExpressionValue((Object)parentContext, (String)"parentContext");
        return new MonoLocalBusTrace<MessageExchange>(parentContext, LocalEventBusInstrumenter.INSTANCE.getINSTRUMENTER(), (MessageExchange)exchange, (Mono<Void>)source);
    }

    @NotNull
    public Flux<EventStreamExchange> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.getDelegate().receive(namedAggregates);
    }
}

