/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry.messaging;

import io.opentelemetry.context.Context;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.SimpleServerCommandExchange;
import me.ahoo.wow.messaging.LocalSendMessageBus;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.opentelemetry.messaging.LocalCommandBusInstrumenter;
import me.ahoo.wow.opentelemetry.messaging.MonoLocalBusTrace;
import me.ahoo.wow.opentelemetry.messaging.TracingMessageBus;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/opentelemetry/messaging/TracingLocalCommandBus;", "Lme/ahoo/wow/opentelemetry/messaging/TracingMessageBus;", "Lme/ahoo/wow/command/CommandBus;", "delegate", "(Lme/ahoo/wow/command/CommandBus;)V", "getDelegate", "()Lme/ahoo/wow/command/CommandBus;", "localSendMessageBus", "Lme/ahoo/wow/messaging/LocalSendMessageBus;", "Lme/ahoo/wow/api/command/CommandMessage;", "Lme/ahoo/wow/command/ServerCommandExchange;", "", "close", "", "receive", "Lreactor/core/publisher/Flux;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "wow-opentelemetry"})
public final class TracingLocalCommandBus
implements TracingMessageBus<CommandBus>,
CommandBus {
    @NotNull
    private final CommandBus delegate;
    @NotNull
    private final LocalSendMessageBus<CommandMessage<?>, ServerCommandExchange<? extends Object>> localSendMessageBus;

    public TracingLocalCommandBus(@NotNull CommandBus delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        if (!(this.getDelegate() instanceof LocalSendMessageBus)) {
            boolean bl = false;
            String string = "delegate must be LocalSendMessageBus.";
            throw new IllegalArgumentException(string.toString());
        }
        CommandBus commandBus = this.getDelegate();
        Intrinsics.checkNotNull((Object)commandBus, (String)"null cannot be cast to non-null type me.ahoo.wow.messaging.LocalSendMessageBus<me.ahoo.wow.api.command.CommandMessage<*>, me.ahoo.wow.command.ServerCommandExchange<out kotlin.Any>>");
        this.localSendMessageBus = (LocalSendMessageBus)commandBus;
    }

    @NotNull
    public CommandBus getDelegate() {
        return this.delegate;
    }

    @NotNull
    public Mono<Void> send(@NotNull CommandMessage<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        SimpleServerCommandExchange exchange = new SimpleServerCommandExchange(message, null, null, null, null, null, 62, null);
        Mono source = this.localSendMessageBus.sendExchange((MessageExchange)exchange);
        Context parentContext = Context.current();
        Intrinsics.checkNotNullExpressionValue((Object)parentContext, (String)"parentContext");
        return new MonoLocalBusTrace<MessageExchange>(parentContext, LocalCommandBusInstrumenter.INSTANCE.getINSTRUMENTER(), (MessageExchange)exchange, (Mono<Void>)source);
    }

    @NotNull
    public Flux<ServerCommandExchange<Object>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.getDelegate().receive(namedAggregates);
    }

    public void close() {
        this.getDelegate().close();
    }
}

