/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00030\u0004B9\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001a"}, d2={"Lme/ahoo/wow/opentelemetry/TraceSubscriber;", "T", "", "O", "Lreactor/core/CoreSubscriber;", "instrumenter", "Lio/opentelemetry/instrumentation/api/instrumenter/Instrumenter;", "", "otelContext", "Lio/opentelemetry/context/Context;", "request", "actual", "(Lio/opentelemetry/instrumentation/api/instrumenter/Instrumenter;Lio/opentelemetry/context/Context;Ljava/lang/Object;Lreactor/core/CoreSubscriber;)V", "Ljava/lang/Object;", "currentContext", "Lreactor/util/context/Context;", "onComplete", "onError", "throwable", "", "onNext", "signal", "(Ljava/lang/Object;)V", "onSubscribe", "subscription", "Lorg/reactivestreams/Subscription;", "wow-opentelemetry"})
public class TraceSubscriber<T, O>
implements CoreSubscriber<O> {
    @NotNull
    private final Instrumenter<T, Unit> instrumenter;
    @NotNull
    private final Context otelContext;
    @NotNull
    private final T request;
    @NotNull
    private final CoreSubscriber<? super O> actual;

    public TraceSubscriber(@NotNull Instrumenter<T, Unit> instrumenter, @NotNull Context otelContext, @NotNull T request, @NotNull CoreSubscriber<? super O> actual) {
        Intrinsics.checkNotNullParameter(instrumenter, (String)"instrumenter");
        Intrinsics.checkNotNullParameter((Object)otelContext, (String)"otelContext");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        this.instrumenter = instrumenter;
        this.otelContext = otelContext;
        this.request = request;
        this.actual = actual;
    }

    @NotNull
    public reactor.util.context.Context currentContext() {
        reactor.util.context.Context context = this.actual.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"currentContext(...)");
        return context;
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        this.actual.onSubscribe(subscription);
    }

    public void onNext(O signal) {
        this.actual.onNext(signal);
    }

    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.instrumenter.end(this.otelContext, this.request, null, throwable);
        this.actual.onError(throwable);
    }

    public void onComplete() {
        this.instrumenter.end(this.otelContext, this.request, null, null);
        this.actual.onComplete();
    }
}

