/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.opentelemetry.messaging;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.infra.Decorator;
import me.ahoo.wow.messaging.MessageBus;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.opentelemetry.TraceMono;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002*\u0012\b\u0001\u0010\u0003*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00010\u0004*\u0014\b\u0002\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00062\b\u0012\u0004\u0012\u0002H\u00050\u0007J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018\u00c0\u0006\u0003"}, d2={"Lme/ahoo/wow/opentelemetry/messaging/TracingMessageBus;", "M", "Lme/ahoo/wow/api/messaging/Message;", "E", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "B", "Lme/ahoo/wow/messaging/MessageBus;", "Lme/ahoo/wow/infra/Decorator;", "producerInstrumenter", "Lio/opentelemetry/instrumentation/api/instrumenter/Instrumenter;", "", "getProducerInstrumenter", "()Lio/opentelemetry/instrumentation/api/instrumenter/Instrumenter;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/core/publisher/Mono;", "receive", "Lreactor/core/publisher/Flux;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "close", "wow-opentelemetry"})
public interface TracingMessageBus<M extends Message<?, ?>, E extends MessageExchange<?, ? extends M>, B extends MessageBus<M, E>>
extends MessageBus<M, E>,
Decorator<B> {
    @NotNull
    public Instrumenter<M, Unit> getProducerInstrumenter();

    @NotNull
    default public Mono<Void> send(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Mono source = ((MessageBus)this.getDelegate()).send(message);
        Context parentContext = Context.current();
        Intrinsics.checkNotNull((Object)parentContext);
        return new TraceMono(parentContext, this.getProducerInstrumenter(), message, source);
    }

    @NotNull
    default public Flux<E> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return ((MessageBus)this.getDelegate()).receive(namedAggregates);
    }

    default public void close() {
        ((MessageBus)this.getDelegate()).close();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static <M extends Message<?, ?>, E extends MessageExchange<?, ? extends M>, B extends MessageBus<M, E>> Mono<Void> send(@NotNull TracingMessageBus<M, E, B> $this, @NotNull M message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            return ((TracingMessageBus)$this).send(message);
        }

        @Deprecated
        @NotNull
        public static <M extends Message<?, ?>, E extends MessageExchange<?, ? extends M>, B extends MessageBus<M, E>> Flux<E> receive(@NotNull TracingMessageBus<M, E, B> $this, @NotNull Set<? extends NamedAggregate> namedAggregates) {
            Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
            return ((TracingMessageBus)$this).receive(namedAggregates);
        }

        @Deprecated
        public static <M extends Message<?, ?>, E extends MessageExchange<?, ? extends M>, B extends MessageBus<M, E>> void close(@NotNull TracingMessageBus<M, E, B> $this) {
            ((TracingMessageBus)$this).close();
        }
    }
}

