/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.query.converter;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.query.converter.ConditionConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ%\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H&\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/query/converter/AbstractConditionConverter;", "T", "Lme/ahoo/wow/query/converter/ConditionConverter;", "<init>", "()V", "today", "condition", "Lme/ahoo/wow/api/query/Condition;", "(Lme/ahoo/wow/api/query/Condition;)Ljava/lang/Object;", "tomorrow", "thisWeek", "nextWeek", "lastWeek", "thisMonth", "lastMonth", "recentDays", "timeRange", "field", "", "from", "Ljava/time/LocalDateTime;", "to", "(Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)Ljava/lang/Object;", "wow-query"})
public abstract class AbstractConditionConverter<T>
implements ConditionConverter<T> {
    @Override
    public T today(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfDay = LocalDateTime.now().with(LocalTime.MIN);
        LocalDateTime endOfDay = LocalDateTime.now().with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfDay);
        Intrinsics.checkNotNull((Object)endOfDay);
        return this.timeRange(string, startOfDay, endOfDay);
    }

    @Override
    public T tomorrow(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfTomorrow = LocalDateTime.now().plusDays(1L).with(LocalTime.MIN);
        LocalDateTime endOfTomorrow = LocalDateTime.now().plusDays(1L).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfTomorrow);
        Intrinsics.checkNotNull((Object)endOfTomorrow);
        return this.timeRange(string, startOfTomorrow, endOfTomorrow);
    }

    @Override
    public T thisWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfWeek = LocalDateTime.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        LocalDateTime endOfWeek = LocalDateTime.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfWeek);
        Intrinsics.checkNotNull((Object)endOfWeek);
        return this.timeRange(string, startOfWeek, endOfWeek);
    }

    @Override
    public T nextWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfNextWeek = LocalDateTime.now().plusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        LocalDateTime endOfNextWeek = LocalDateTime.now().plusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfNextWeek);
        Intrinsics.checkNotNull((Object)endOfNextWeek);
        return this.timeRange(string, startOfNextWeek, endOfNextWeek);
    }

    @Override
    public T lastWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfLastWeek = LocalDateTime.now().minusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        LocalDateTime endOfLastWeek = LocalDateTime.now().minusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfLastWeek);
        Intrinsics.checkNotNull((Object)endOfLastWeek);
        return this.timeRange(string, startOfLastWeek, endOfLastWeek);
    }

    @Override
    public T thisMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfMonth = LocalDateTime.now().withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime endOfMonth = LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfMonth);
        Intrinsics.checkNotNull((Object)endOfMonth);
        return this.timeRange(string, startOfMonth, endOfMonth);
    }

    @Override
    public T lastMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        LocalDateTime startOfLastMonth = LocalDateTime.now().minusMonths(1L).withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime endOfLastMonth = LocalDateTime.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfLastMonth);
        Intrinsics.checkNotNull((Object)endOfLastMonth);
        return this.timeRange(string, startOfLastMonth, endOfLastMonth);
    }

    @Override
    public T recentDays(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        Number days = (Number)object;
        LocalDateTime startOfRecentDays = LocalDateTime.now().minusDays(days.longValue() - 1L).with(LocalTime.MIN);
        LocalDateTime endOfRecentDays = LocalDateTime.now().with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfRecentDays);
        Intrinsics.checkNotNull((Object)endOfRecentDays);
        return this.timeRange(string, startOfRecentDays, endOfRecentDays);
    }

    public abstract T timeRange(@NotNull String var1, @NotNull LocalDateTime var2, @NotNull LocalDateTime var3);
}

