/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.query.converter;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.query.converter.ConditionConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\nJ#\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/query/converter/AbstractConditionConverter;", "T", "Lme/ahoo/wow/query/converter/ConditionConverter;", "<init>", "()V", "now", "Ljava/time/OffsetDateTime;", "condition", "Lme/ahoo/wow/api/query/Condition;", "today", "(Lme/ahoo/wow/api/query/Condition;)Ljava/lang/Object;", "beforeToday", "tomorrow", "thisWeek", "nextWeek", "lastWeek", "thisMonth", "lastMonth", "recentDays", "timeRange", "field", "", "from", "to", "(Ljava/lang/String;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;)Ljava/lang/Object;", "wow-query"})
public abstract class AbstractConditionConverter<T>
implements ConditionConverter<T> {
    private final OffsetDateTime now(Condition condition) {
        ZoneId zoneId = condition.zoneId();
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        ZoneId zoneId2 = zoneId;
        OffsetDateTime offsetDateTime = OffsetDateTime.now(zoneId2);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
        return offsetDateTime;
    }

    @Override
    public T today(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfDay = now.with(LocalTime.MIN);
        OffsetDateTime endOfDay = now.with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfDay);
        Intrinsics.checkNotNull((Object)endOfDay);
        return this.timeRange(string, startOfDay, endOfDay);
    }

    @Override
    public T beforeToday(@NotNull Condition condition) {
        LocalTime localTime;
        Object conditionValue;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object object = conditionValue = condition.getValue();
        if (object instanceof Number) {
            localTime = LocalTime.ofSecondOfDay(((Number)conditionValue).longValue());
        } else if (object instanceof String) {
            localTime = LocalTime.parse((CharSequence)conditionValue);
        } else if (object instanceof LocalTime) {
            localTime = (LocalTime)conditionValue;
        } else {
            throw new IllegalArgumentException("Unsupported condition value type:" + conditionValue.getClass());
        }
        LocalTime time = localTime;
        long ltDateTime = this.now(condition).with(time).toInstant().toEpochMilli();
        Condition ltCondition = Condition.Companion.lt(condition.getField(), (Object)ltDateTime);
        return this.lt(ltCondition);
    }

    @Override
    public T tomorrow(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfTomorrow = now.plusDays(1L).with(LocalTime.MIN);
        OffsetDateTime endOfTomorrow = now.plusDays(1L).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfTomorrow);
        Intrinsics.checkNotNull((Object)endOfTomorrow);
        return this.timeRange(string, startOfTomorrow, endOfTomorrow);
    }

    @Override
    public T thisWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfWeek = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        OffsetDateTime endOfWeek = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfWeek);
        Intrinsics.checkNotNull((Object)endOfWeek);
        return this.timeRange(string, startOfWeek, endOfWeek);
    }

    @Override
    public T nextWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfNextWeek = now.plusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        OffsetDateTime endOfNextWeek = now.plusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfNextWeek);
        Intrinsics.checkNotNull((Object)endOfNextWeek);
        return this.timeRange(string, startOfNextWeek, endOfNextWeek);
    }

    @Override
    public T lastWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfLastWeek = now.minusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        OffsetDateTime endOfLastWeek = now.minusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfLastWeek);
        Intrinsics.checkNotNull((Object)endOfLastWeek);
        return this.timeRange(string, startOfLastWeek, endOfLastWeek);
    }

    @Override
    public T thisMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfMonth = now.withDayOfMonth(1).with(LocalTime.MIN);
        OffsetDateTime endOfMonth = now.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfMonth);
        Intrinsics.checkNotNull((Object)endOfMonth);
        return this.timeRange(string, startOfMonth, endOfMonth);
    }

    @Override
    public T lastMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfLastMonth = now.minusMonths(1L).withDayOfMonth(1).with(LocalTime.MIN);
        OffsetDateTime endOfLastMonth = now.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfLastMonth);
        Intrinsics.checkNotNull((Object)endOfLastMonth);
        return this.timeRange(string, startOfLastMonth, endOfLastMonth);
    }

    @Override
    public T recentDays(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        Number days = (Number)object;
        OffsetDateTime startOfRecentDays = now.minusDays(days.longValue() - 1L).with(LocalTime.MIN);
        OffsetDateTime endOfRecentDays = now.with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfRecentDays);
        Intrinsics.checkNotNull((Object)endOfRecentDays);
        return this.timeRange(string, startOfRecentDays, endOfRecentDays);
    }

    public final T timeRange(@NotNull String field, @NotNull OffsetDateTime from, @NotNull OffsetDateTime to) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        long fromEpoch = from.toInstant().toEpochMilli();
        long toEpoch = to.toInstant().toEpochMilli();
        Condition betweenCondition = Condition.Companion.between(field, (Object)fromEpoch, (Object)toEpoch);
        return this.between(betweenCondition);
    }
}

