/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query.converter

import me.ahoo.wow.api.query.Projection
import me.ahoo.wow.api.query.isEmpty

abstract class AbstractProjectionConverter<T> : ProjectionConverter<T> {
    abstract val fieldConverter: FieldConverter
    override fun convert(projection: Projection): T {
        if (projection.isEmpty()) {
            return internalConvert(projection)
        }
        val converted = Projection(
            include = projection.include.map { fieldConverter.convert(it) },
            exclude = projection.exclude.map { fieldConverter.convert(it) }
        )
        return internalConvert(converted)
    }

    protected abstract fun internalConvert(projection: Projection): T
}
