/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.query.converter;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.Operator;
import me.ahoo.wow.query.converter.ConditionConverter;
import me.ahoo.wow.query.converter.DeleteConditionGuard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010 \u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\"\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010#\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010$\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010%\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010&\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010'\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0015\u0010(\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020*2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0015\u00100\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00101\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00102\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00103\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00104\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00105\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00106\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00107\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00108\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u00109\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\bJ1\u0010:\u001a\u00028\u00002\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020*2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0004\u00a2\u0006\u0002\u0010?\u00a8\u0006@"}, d2={"Lme/ahoo/wow/query/converter/AbstractConditionConverter;", "T", "Lme/ahoo/wow/query/converter/ConditionConverter;", "<init>", "()V", "convert", "condition", "Lme/ahoo/wow/api/query/Condition;", "(Lme/ahoo/wow/api/query/Condition;)Ljava/lang/Object;", "internalConvert", "and", "or", "nor", "id", "aggregateId", "aggregateIds", "ids", "tenantId", "ownerId", "all", "eq", "ne", "gt", "lt", "gte", "lte", "contains", "isIn", "notIn", "between", "allIn", "startsWith", "endsWith", "elemMatch", "isNull", "notNull", "isTrue", "isFalse", "exists", "deleted", "raw", "now", "Ljava/time/OffsetDateTime;", "toDate", "", "time", "datePattern", "Ljava/time/format/DateTimeFormatter;", "today", "beforeToday", "tomorrow", "thisWeek", "nextWeek", "lastWeek", "thisMonth", "lastMonth", "recentDays", "earlierDays", "timeRange", "field", "", "from", "to", "(Ljava/lang/String;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/format/DateTimeFormatter;)Ljava/lang/Object;", "wow-query"})
public abstract class AbstractConditionConverter<T>
implements ConditionConverter<T> {
    @Override
    public T convert(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Condition convertedCondition = DeleteConditionGuard.INSTANCE.guard(condition);
        return this.internalConvert(convertedCondition);
    }

    protected final T internalConvert(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return switch (WhenMappings.$EnumSwitchMapping$0[condition.getOperator().ordinal()]) {
            case 1 -> this.and(condition);
            case 2 -> this.or(condition);
            case 3 -> this.nor(condition);
            case 4 -> this.id(condition);
            case 5 -> this.ids(condition);
            case 6 -> this.aggregateId(condition);
            case 7 -> this.aggregateIds(condition);
            case 8 -> this.tenantId(condition);
            case 9 -> this.ownerId(condition);
            case 10 -> this.all(condition);
            case 11 -> this.eq(condition);
            case 12 -> this.ne(condition);
            case 13 -> this.gt(condition);
            case 14 -> this.lt(condition);
            case 15 -> this.gte(condition);
            case 16 -> this.lte(condition);
            case 17 -> this.contains(condition);
            case 18 -> this.isIn(condition);
            case 19 -> this.notIn(condition);
            case 20 -> this.between(condition);
            case 21 -> this.allIn(condition);
            case 22 -> this.startsWith(condition);
            case 23 -> this.endsWith(condition);
            case 24 -> this.elemMatch(condition);
            case 25 -> this.isNull(condition);
            case 26 -> this.notNull(condition);
            case 27 -> this.isTrue(condition);
            case 28 -> this.isFalse(condition);
            case 29 -> this.exists(condition);
            case 30 -> this.deleted(condition);
            case 31 -> this.today(condition);
            case 32 -> this.beforeToday(condition);
            case 33 -> this.tomorrow(condition);
            case 34 -> this.thisWeek(condition);
            case 35 -> this.nextWeek(condition);
            case 36 -> this.lastWeek(condition);
            case 37 -> this.thisMonth(condition);
            case 38 -> this.lastMonth(condition);
            case 39 -> this.recentDays(condition);
            case 40 -> this.earlierDays(condition);
            case 41 -> this.raw(condition);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public abstract T and(@NotNull Condition var1);

    public abstract T or(@NotNull Condition var1);

    public abstract T nor(@NotNull Condition var1);

    public abstract T id(@NotNull Condition var1);

    public abstract T aggregateId(@NotNull Condition var1);

    public abstract T aggregateIds(@NotNull Condition var1);

    public abstract T ids(@NotNull Condition var1);

    public abstract T tenantId(@NotNull Condition var1);

    public abstract T ownerId(@NotNull Condition var1);

    public abstract T all(@NotNull Condition var1);

    public abstract T eq(@NotNull Condition var1);

    public abstract T ne(@NotNull Condition var1);

    public abstract T gt(@NotNull Condition var1);

    public abstract T lt(@NotNull Condition var1);

    public abstract T gte(@NotNull Condition var1);

    public abstract T lte(@NotNull Condition var1);

    public abstract T contains(@NotNull Condition var1);

    public abstract T isIn(@NotNull Condition var1);

    public abstract T notIn(@NotNull Condition var1);

    public abstract T between(@NotNull Condition var1);

    public abstract T allIn(@NotNull Condition var1);

    public abstract T startsWith(@NotNull Condition var1);

    public abstract T endsWith(@NotNull Condition var1);

    public abstract T elemMatch(@NotNull Condition var1);

    public abstract T isNull(@NotNull Condition var1);

    public abstract T notNull(@NotNull Condition var1);

    public abstract T isTrue(@NotNull Condition var1);

    public abstract T isFalse(@NotNull Condition var1);

    public abstract T exists(@NotNull Condition var1);

    public abstract T deleted(@NotNull Condition var1);

    public abstract T raw(@NotNull Condition var1);

    private final OffsetDateTime now(Condition condition) {
        ZoneId zoneId = condition.zoneId();
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        ZoneId zoneId2 = zoneId;
        OffsetDateTime offsetDateTime = OffsetDateTime.now(zoneId2);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
        return offsetDateTime;
    }

    private final Object toDate(OffsetDateTime time, DateTimeFormatter datePattern) {
        return datePattern != null ? time.format(datePattern) : Long.valueOf(time.toInstant().toEpochMilli());
    }

    protected final T today(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfDay = now.with(LocalTime.MIN);
        OffsetDateTime endOfDay = now.with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfDay);
        Intrinsics.checkNotNull((Object)endOfDay);
        return this.timeRange(string, startOfDay, endOfDay, condition.datePattern());
    }

    protected final T beforeToday(@NotNull Condition condition) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Object conditionValue = condition.getValue();
        if (conditionValue instanceof Number) {
            localTime = LocalTime.ofSecondOfDay(((Number)conditionValue).longValue());
        } else if (conditionValue instanceof String) {
            localTime = LocalTime.parse((CharSequence)conditionValue);
        } else if (conditionValue instanceof LocalTime) {
            localTime = (LocalTime)conditionValue;
        } else {
            throw new IllegalArgumentException("Unsupported condition value type:" + conditionValue.getClass());
        }
        LocalTime time = localTime;
        OffsetDateTime now = this.now(condition).with(time);
        Intrinsics.checkNotNull((Object)now);
        Object ltDate = this.toDate(now, condition.datePattern());
        Condition ltCondition = Condition.Companion.lt(condition.getField(), ltDate);
        return this.lt(ltCondition);
    }

    protected final T tomorrow(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfTomorrow = now.plusDays(1L).with(LocalTime.MIN);
        OffsetDateTime endOfTomorrow = now.plusDays(1L).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfTomorrow);
        Intrinsics.checkNotNull((Object)endOfTomorrow);
        return this.timeRange(string, startOfTomorrow, endOfTomorrow, condition.datePattern());
    }

    protected final T thisWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfWeek = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        OffsetDateTime endOfWeek = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfWeek);
        Intrinsics.checkNotNull((Object)endOfWeek);
        return this.timeRange(string, startOfWeek, endOfWeek, condition.datePattern());
    }

    protected final T nextWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfNextWeek = now.plusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        OffsetDateTime endOfNextWeek = now.plusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfNextWeek);
        Intrinsics.checkNotNull((Object)endOfNextWeek);
        return this.timeRange(string, startOfNextWeek, endOfNextWeek, condition.datePattern());
    }

    protected final T lastWeek(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfLastWeek = now.minusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
        OffsetDateTime endOfLastWeek = now.minusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfLastWeek);
        Intrinsics.checkNotNull((Object)endOfLastWeek);
        return this.timeRange(string, startOfLastWeek, endOfLastWeek, condition.datePattern());
    }

    protected final T thisMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfMonth = now.withDayOfMonth(1).with(LocalTime.MIN);
        OffsetDateTime endOfMonth = now.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfMonth);
        Intrinsics.checkNotNull((Object)endOfMonth);
        return this.timeRange(string, startOfMonth, endOfMonth, condition.datePattern());
    }

    protected final T lastMonth(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        OffsetDateTime startOfLastMonth = now.minusMonths(1L).withDayOfMonth(1).with(LocalTime.MIN);
        OffsetDateTime endOfLastMonth = now.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfLastMonth);
        Intrinsics.checkNotNull((Object)endOfLastMonth);
        return this.timeRange(string, startOfLastMonth, endOfLastMonth, condition.datePattern());
    }

    protected final T recentDays(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        Number days = (Number)object;
        OffsetDateTime startOfRecentDays = now.minusDays(days.longValue() - 1L).with(LocalTime.MIN);
        OffsetDateTime endOfRecentDays = now.with(LocalTime.MAX);
        String string = condition.getField();
        Intrinsics.checkNotNull((Object)startOfRecentDays);
        Intrinsics.checkNotNull((Object)endOfRecentDays);
        return this.timeRange(string, startOfRecentDays, endOfRecentDays, condition.datePattern());
    }

    protected final T earlierDays(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        OffsetDateTime now = this.now(condition);
        Object object = condition.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        Number days = (Number)object;
        OffsetDateTime endOfEarlierDays = now.minusDays(days.longValue() - 1L).with(LocalTime.MIN);
        Intrinsics.checkNotNull((Object)endOfEarlierDays);
        Object toDate = this.toDate(endOfEarlierDays, condition.datePattern());
        Condition ltCondition = Condition.Companion.lt(condition.getField(), toDate);
        return this.lt(ltCondition);
    }

    protected final T timeRange(@NotNull String field, @NotNull OffsetDateTime from, @NotNull OffsetDateTime to, @Nullable DateTimeFormatter datePattern) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Object fromDate = this.toDate(from, datePattern);
        Object toDate = this.toDate(to, datePattern);
        Condition betweenCondition = Condition.Companion.between(field, fromDate, toDate);
        return this.between(betweenCondition);
    }

    public static /* synthetic */ Object timeRange$default(AbstractConditionConverter abstractConditionConverter, String string, OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2, DateTimeFormatter dateTimeFormatter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: timeRange");
        }
        if ((n & 8) != 0) {
            dateTimeFormatter = null;
        }
        return abstractConditionConverter.timeRange(string, offsetDateTime, offsetDateTime2, dateTimeFormatter);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operator.values().length];
            try {
                nArray[Operator.AND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.OR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.ID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.IDS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.AGGREGATE_ID.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.AGGREGATE_IDS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.TENANT_ID.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.OWNER_ID.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.ALL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.EQ.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.GT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.LT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.GTE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.LTE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.CONTAINS.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.IN.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NOT_IN.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.BETWEEN.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.ALL_IN.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.STARTS_WITH.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.ENDS_WITH.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.ELEM_MATCH.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NULL.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NOT_NULL.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.TRUE.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.FALSE.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.EXISTS.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.DELETED.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.TODAY.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.BEFORE_TODAY.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.TOMORROW.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.THIS_WEEK.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NEXT_WEEK.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.LAST_WEEK.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.THIS_MONTH.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.LAST_MONTH.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.RECENT_DAYS.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.EARLIER_DAYS.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.RAW.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

