/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshot;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.infra.TypeNameMapper;
import me.ahoo.wow.modeling.annotation.StateAggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.r2dbc.Database;
import me.ahoo.wow.r2dbc.R2dbcSnapshotRepository;
import me.ahoo.wow.r2dbc.SnapshotSchema;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00120\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J7\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/ahoo/wow/r2dbc/R2dbcSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "database", "Lme/ahoo/wow/r2dbc/Database;", "snapshotSchema", "Lme/ahoo/wow/r2dbc/SnapshotSchema;", "(Lme/ahoo/wow/r2dbc/Database;Lme/ahoo/wow/r2dbc/SnapshotSchema;)V", "findAggregateId", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/api/modeling/AggregateId;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "cursorId", "", "limit", "", "load", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "aggregateId", "mapSnapshot", "expectedVersion", "readable", "Lio/r2dbc/spi/Readable;", "(Lme/ahoo/wow/api/modeling/AggregateId;Ljava/lang/Integer;Lio/r2dbc/spi/Readable;)Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "save", "Ljava/lang/Void;", "snapshot", "wow-r2dbc"})
public final class R2dbcSnapshotRepository
implements SnapshotRepository {
    @NotNull
    private final Database database;
    @NotNull
    private final SnapshotSchema snapshotSchema;

    public R2dbcSnapshotRepository(@NotNull Database database, @NotNull SnapshotSchema snapshotSchema) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)snapshotSchema, (String)"snapshotSchema");
        this.database = database;
        this.snapshotSchema = snapshotSchema;
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Mono mono = Flux.usingWhen(this.database.createConnection(aggregateId), arg_0 -> R2dbcSnapshotRepository.load$lambda$0(new Function1(this, aggregateId){
            final /* synthetic */ R2dbcSnapshotRepository this$0;
            final /* synthetic */ AggregateId $aggregateId;
            {
                this.this$0 = $receiver;
                this.$aggregateId = $aggregateId;
                super(1);
            }

            public final Publisher<? extends Result> invoke(Connection it) {
                return it.createStatement(R2dbcSnapshotRepository.access$getSnapshotSchema$p(this.this$0).load(this.$aggregateId)).bind(0, (Object)this.$aggregateId.getId()).execute();
            }
        }, arg_0), arg_0 -> R2dbcSnapshotRepository.load$lambda$1(load.2.INSTANCE, arg_0)).flatMap(arg_0 -> R2dbcSnapshotRepository.load$lambda$2((Function1)new Function1<Result, Publisher<? extends Snapshot<S>>>(this, aggregateId){
            final /* synthetic */ R2dbcSnapshotRepository this$0;
            final /* synthetic */ AggregateId $aggregateId;
            {
                this.this$0 = $receiver;
                this.$aggregateId = $aggregateId;
                super(1);
            }

            public final Publisher<? extends Snapshot<S>> invoke(Result it) {
                return it.map(arg_0 -> load.3.invoke$lambda$0((Function1)new Function1<Readable, Snapshot<S>>(this.this$0, this.$aggregateId){
                    final /* synthetic */ R2dbcSnapshotRepository this$0;
                    final /* synthetic */ AggregateId $aggregateId;
                    {
                        this.this$0 = $receiver;
                        this.$aggregateId = $aggregateId;
                        super(1);
                    }

                    public final Snapshot<S> invoke(Readable readable) {
                        Intrinsics.checkNotNullExpressionValue((Object)readable, (String)"readable");
                        return R2dbcSnapshotRepository.access$mapSnapshot(this.this$0, this.$aggregateId, null, readable);
                    }
                }, arg_0));
            }

            private static final Snapshot invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Snapshot)$tmp0.invoke(p0);
            }
        }, arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun <S : Any> l\u2026            .next()\n    }");
        return mono;
    }

    private final <S> Snapshot<S> mapSnapshot(AggregateId aggregateId, Integer expectedVersion, Readable readable) {
        Object object = readable.get("aggregate_id", String.class);
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"checkNotNull(readable.ge\u2026id\", String::class.java))");
        String actualAggregateId = (String)object;
        if (!Intrinsics.areEqual((Object)aggregateId.getId(), (Object)actualAggregateId)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object2 = readable.get("tenant_id", String.class);
        if (object2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"checkNotNull(readable.ge\u2026id\", String::class.java))");
        String tenantId = (String)object2;
        if (!Intrinsics.areEqual((Object)tenantId, (Object)aggregateId.getTenantId())) {
            boolean $i$a$-require-R2dbcSnapshotRepository$mapSnapshot$22 = false;
            String $i$a$-require-R2dbcSnapshotRepository$mapSnapshot$22 = "The aggregated tenantId[" + aggregateId.getTenantId() + "] does not match the tenantId:[" + tenantId + "] stored in the eventStore";
            throw new IllegalArgumentException($i$a$-require-R2dbcSnapshotRepository$mapSnapshot$22.toString());
        }
        Object object3 = readable.get("version", Integer.TYPE);
        if (object3 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"checkNotNull(readable.ge\u2026rsion\", Int::class.java))");
        int actualVersion = ((Number)object3).intValue();
        Integer n = expectedVersion;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (!(actualVersion == expectedVersion)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
        Object object4 = readable.get("create_time", Long.TYPE);
        if (object4 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"checkNotNull(readable.ge\u2026time\", Long::class.java))");
        long snapshotTime = ((Number)object4).longValue();
        Object object5 = readable.get("state_type", String.class);
        if (object5 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"checkNotNull(readable.ge\u2026pe\", String::class.java))");
        StateAggregateMetadata metadata = StateAggregateMetadataParserKt.asStateAggregateMetadata((Class)TypeNameMapper.INSTANCE.asType((String)object5));
        Object object6 = readable.get("state", String.class);
        if (object6 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"checkNotNull(readable.ge\u2026te\", String::class.java))");
        String state = (String)object6;
        Object stateRoot = JsonSerializerKt.asObject((String)state, (Class)metadata.getAggregateType());
        Object object7 = readable.get("deleted", Boolean.TYPE);
        if (object7 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"checkNotNull(readable.ge\u2026d\", Boolean::class.java))");
        boolean deleted = (Boolean)object7;
        return (Snapshot)new SimpleSnapshot(StateAggregate.Companion.asStateAggregate(metadata, aggregateId, stateRoot, actualVersion, deleted), snapshotTime);
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Mono mono = Flux.usingWhen(this.database.createConnection(snapshot.getAggregateId()), arg_0 -> R2dbcSnapshotRepository.save$lambda$5(new Function1(this, snapshot){
            final /* synthetic */ R2dbcSnapshotRepository this$0;
            final /* synthetic */ Snapshot<S> $snapshot;
            {
                this.this$0 = $receiver;
                this.$snapshot = $snapshot;
                super(1);
            }

            public final Publisher<? extends Result> invoke(Connection it) {
                return it.createStatement(R2dbcSnapshotRepository.access$getSnapshotSchema$p(this.this$0).save(this.$snapshot.getAggregateId())).bind(0, (Object)this.$snapshot.getAggregateId().getId()).bind(1, (Object)this.$snapshot.getAggregateId().getTenantId()).bind(2, (Object)this.$snapshot.getVersion()).bind(3, (Object)this.$snapshot.getStateRoot().getClass().getName()).bind(4, (Object)JsonSerializerKt.asJsonString((Object)this.$snapshot.getStateRoot())).bind(5, (Object)this.$snapshot.getSnapshotTime()).bind(6, (Object)this.$snapshot.getDeleted()).execute();
            }
        }, arg_0), arg_0 -> R2dbcSnapshotRepository.save$lambda$6(save.2.INSTANCE, arg_0)).flatMap(arg_0 -> R2dbcSnapshotRepository.save$lambda$7(save.3.INSTANCE, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun <S : Any> s\u2026            .then()\n    }");
        return mono;
    }

    @NotNull
    public Flux<AggregateId> findAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String cursorId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)cursorId, (String)"cursorId");
        throw new UnsupportedOperationException();
    }

    private static final Publisher load$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher load$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher load$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher save$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher save$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher save$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ SnapshotSchema access$getSnapshotSchema$p(R2dbcSnapshotRepository $this) {
        return $this.snapshotSchema;
    }

    public static final /* synthetic */ Snapshot access$mapSnapshot(R2dbcSnapshotRepository $this, AggregateId aggregateId, Integer expectedVersion, Readable readable) {
        return $this.mapSnapshot(aggregateId, expectedVersion, readable);
    }
}

