/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.r2dbc;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.r2dbc.SnapshotStatement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/r2dbc/SnapshotStatementGenerator;", "", "<init>", "()V", "statements", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lme/ahoo/wow/r2dbc/SnapshotStatement;", "generate", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "tableName", "wow-r2dbc"})
public final class SnapshotStatementGenerator {
    @NotNull
    public static final SnapshotStatementGenerator INSTANCE = new SnapshotStatementGenerator();
    @NotNull
    private static final ConcurrentHashMap<String, SnapshotStatement> statements = new ConcurrentHashMap();

    private SnapshotStatementGenerator() {
    }

    @NotNull
    public final SnapshotStatement generate(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String tableName = namedAggregate.getAggregateName() + "_snapshot";
        return this.generate(tableName);
    }

    @NotNull
    public final SnapshotStatement generate(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        SnapshotStatement snapshotStatement = statements.computeIfAbsent(tableName, arg_0 -> SnapshotStatementGenerator.generate$lambda$1(arg_0 -> SnapshotStatementGenerator.generate$lambda$0(tableName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)snapshotStatement, (String)"computeIfAbsent(...)");
        return snapshotStatement;
    }

    private static final SnapshotStatement generate$lambda$0(String $tableName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String loadStatement = "select * from " + $tableName + " where aggregate_id=? order by version desc limit 1";
        String loadByVersionStatement = "select * from " + $tableName + " where aggregate_id=? and version=?";
        String saveStatement = ((Object)StringsKt.trim((CharSequence)("\n     replace into " + $tableName + "\n     (aggregate_id,tenant_id,version,state_type,state,event_id,first_operator,operator,first_event_time,event_time,snapshot_time,deleted)\n     values \n     (?,?,?,?,?,?,?,?,?,?,?,?)\n     "))).toString();
        String scanStatement = "select aggregate_id,tenant_id from " + $tableName + " where aggregate_id > ? order by aggregate_id asc limit ?";
        return new SnapshotStatement(loadStatement, loadByVersionStatement, saveStatement, scanStatement);
    }

    private static final SnapshotStatement generate$lambda$1(Function1 $tmp0, Object p0) {
        return (SnapshotStatement)$tmp0.invoke(p0);
    }
}

