/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.r2dbc;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.r2dbc.EventStreamStatement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/r2dbc/EventStreamStatementGenerator;", "", "<init>", "()V", "statements", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lme/ahoo/wow/r2dbc/EventStreamStatement;", "generate", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "loadByVersionSql", "tableName", "loadByEventTimeSql", "appendSql", "wow-r2dbc"})
public final class EventStreamStatementGenerator {
    @NotNull
    public static final EventStreamStatementGenerator INSTANCE = new EventStreamStatementGenerator();
    @NotNull
    private static final ConcurrentHashMap<String, EventStreamStatement> statements = new ConcurrentHashMap();

    private EventStreamStatementGenerator() {
    }

    @NotNull
    public final EventStreamStatement generate(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String tableName = namedAggregate.getAggregateName() + "_event_stream";
        return this.generate(tableName);
    }

    private final String loadByVersionSql(String tableName) {
        return "select * from " + tableName + " where aggregate_id=? and version between ? and ? order by version";
    }

    private final String loadByEventTimeSql(String tableName) {
        return "select * from " + tableName + " where aggregate_id=? and create_time between ? and ? order by version";
    }

    private final String appendSql(String tableName) {
        return ((Object)StringsKt.trim((CharSequence)("\n        insert into " + tableName + " (id,aggregate_id,tenant_id,owner_id,request_id,command_id,version,header,body,size,create_time) \n        values\n        (?,?,?,?,?,?,?,?,?,?,?)\n    "))).toString();
    }

    @NotNull
    public final EventStreamStatement generate(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        EventStreamStatement eventStreamStatement = statements.computeIfAbsent(tableName, arg_0 -> EventStreamStatementGenerator.generate$lambda$1(arg_0 -> EventStreamStatementGenerator.generate$lambda$0(tableName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)eventStreamStatement, (String)"computeIfAbsent(...)");
        return eventStreamStatement;
    }

    private static final EventStreamStatement generate$lambda$0(String $tableName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new EventStreamStatement(INSTANCE.loadByVersionSql($tableName), INSTANCE.loadByEventTimeSql($tableName), INSTANCE.appendSql($tableName));
    }

    private static final EventStreamStatement generate$lambda$1(Function1 $tmp0, Object p0) {
        return (EventStreamStatement)$tmp0.invoke(p0);
    }
}

