/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.modeling.OwnerId;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshot;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.infra.TypeNameMapper;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.annotation.StateAggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.ReadOnlyStateAggregate;
import me.ahoo.wow.r2dbc.Database;
import me.ahoo.wow.r2dbc.R2dbcSnapshotRepository;
import me.ahoo.wow.r2dbc.SnapshotSchema;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\r\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000eH\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lme/ahoo/wow/r2dbc/R2dbcSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "database", "Lme/ahoo/wow/r2dbc/Database;", "snapshotSchema", "Lme/ahoo/wow/r2dbc/SnapshotSchema;", "<init>", "(Lme/ahoo/wow/r2dbc/Database;Lme/ahoo/wow/r2dbc/SnapshotSchema;)V", "name", "", "getName", "()Ljava/lang/String;", "load", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "mapSnapshot", "readable", "Lio/r2dbc/spi/Readable;", "save", "Ljava/lang/Void;", "snapshot", "scanAggregateId", "Lreactor/core/publisher/Flux;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "afterId", "limit", "", "Companion", "wow-r2dbc"})
public final class R2dbcSnapshotRepository
implements SnapshotRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Database database;
    @NotNull
    private final SnapshotSchema snapshotSchema;
    @NotNull
    public static final String NAME = "r2dbc";

    public R2dbcSnapshotRepository(@NotNull Database database, @NotNull SnapshotSchema snapshotSchema) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)snapshotSchema, (String)"snapshotSchema");
        this.database = database;
        this.snapshotSchema = snapshotSchema;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Mono mono = Flux.usingWhen(this.database.createConnection(aggregateId), arg_0 -> R2dbcSnapshotRepository.load$lambda$1(arg_0 -> R2dbcSnapshotRepository.load$lambda$0(this, aggregateId, arg_0), arg_0), arg_0 -> R2dbcSnapshotRepository.load$lambda$2(load.2.INSTANCE, arg_0)).flatMap(arg_0 -> R2dbcSnapshotRepository.load$lambda$4(arg_0 -> R2dbcSnapshotRepository.load$lambda$3(this, aggregateId, arg_0), arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    private final <S> Snapshot<S> mapSnapshot(AggregateId aggregateId, Readable readable) {
        String string;
        String firstOperator;
        String string2;
        String eventId;
        Object object = readable.get("aggregate_id", String.class);
        if (object == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        String actualAggregateId = (String)object;
        if (!Intrinsics.areEqual((Object)aggregateId.getId(), (Object)actualAggregateId)) {
            String string4 = "Failed requirement.";
            throw new IllegalArgumentException(string4.toString());
        }
        Object object2 = readable.get("tenant_id", String.class);
        if (object2 == null) {
            String string5 = "Required value was null.";
            throw new IllegalStateException(string5.toString());
        }
        String tenantId = (String)object2;
        if (!Intrinsics.areEqual((Object)tenantId, (Object)aggregateId.getTenantId())) {
            boolean $i$a$-require-R2dbcSnapshotRepository$mapSnapshot$22 = false;
            String $i$a$-require-R2dbcSnapshotRepository$mapSnapshot$22 = "The aggregated tenantId[" + aggregateId.getTenantId() + "] does not match the tenantId:[" + tenantId + "] stored in the eventStore";
            throw new IllegalArgumentException($i$a$-require-R2dbcSnapshotRepository$mapSnapshot$22.toString());
        }
        String ownerId = OwnerId.Companion.orDefaultOwnerId((String)readable.get("owner_id", String.class));
        Object object3 = readable.get("version", Integer.TYPE);
        if (object3 == null) {
            String string6 = "Required value was null.";
            throw new IllegalStateException(string6.toString());
        }
        int actualVersion = ((Number)object3).intValue();
        String string7 = (String)readable.get("event_id", String.class);
        if (string7 == null) {
            string7 = eventId = "";
        }
        if ((string2 = (String)readable.get("first_operator", String.class)) == null) {
            string2 = firstOperator = "";
        }
        if ((string = (String)readable.get("operator", String.class)) == null) {
            string = "";
        }
        String operator = string;
        Long l = (Long)readable.get("first_event_time", Long.TYPE);
        long firstEventTime = l != null ? l : 0L;
        Long l2 = (Long)readable.get("event_time", Long.TYPE);
        long eventTime = l2 != null ? l2 : 0L;
        Object object4 = readable.get("snapshot_time", Long.TYPE);
        if (object4 == null) {
            String string8 = "Required value was null.";
            throw new IllegalStateException(string8.toString());
        }
        long snapshotTime = ((Number)object4).longValue();
        Object object5 = readable.get("state_type", String.class);
        if (object5 == null) {
            String string9 = "Required value was null.";
            throw new IllegalStateException(string9.toString());
        }
        StateAggregateMetadata metadata = StateAggregateMetadataParserKt.stateAggregateMetadata((Class)TypeNameMapper.INSTANCE.toType((String)object5));
        Object object6 = readable.get("state", String.class);
        if (object6 == null) {
            String string10 = "Required value was null.";
            throw new IllegalStateException(string10.toString());
        }
        String state = (String)object6;
        Object stateRoot = JsonSerializerKt.toObject((String)state, (Class)metadata.getAggregateType());
        Object object7 = readable.get("deleted", Boolean.TYPE);
        if (object7 == null) {
            String string11 = "Required value was null.";
            throw new IllegalStateException(string11.toString());
        }
        boolean deleted = (Boolean)object7;
        return (Snapshot)new SimpleSnapshot((ReadOnlyStateAggregate)ConstructorStateAggregateFactory.toStateAggregate((StateAggregateMetadata)metadata, (AggregateId)aggregateId, (Object)stateRoot, (int)actualVersion, (String)ownerId, (String)eventId, (String)firstOperator, (String)operator, (long)firstEventTime, (long)eventTime, (boolean)deleted), snapshotTime);
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Mono mono = Flux.usingWhen(this.database.createConnection(snapshot.getAggregateId()), arg_0 -> R2dbcSnapshotRepository.save$lambda$1(arg_0 -> R2dbcSnapshotRepository.save$lambda$0(this, snapshot, arg_0), arg_0), arg_0 -> R2dbcSnapshotRepository.save$lambda$2(save.2.INSTANCE, arg_0)).flatMap(arg_0 -> R2dbcSnapshotRepository.save$lambda$4(R2dbcSnapshotRepository::save$lambda$3, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    public Flux<AggregateId> scanAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String afterId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)afterId, (String)"afterId");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId$default((NamedAggregate)namedAggregate, (String)"0", null, (int)2, null);
        Flux flux = Flux.usingWhen(this.database.createConnection((AggregateId)aggregateId), arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$1(arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$0(this, aggregateId, afterId, limit, arg_0), arg_0), arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$2(scanAggregateId.2.INSTANCE, arg_0)).flatMap(arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$4(arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$3(namedAggregate, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMap(...)");
        return flux;
    }

    private static final Publisher load$lambda$0(R2dbcSnapshotRepository this$0, AggregateId $aggregateId, Connection it) {
        return it.createStatement(this$0.snapshotSchema.load($aggregateId)).bind(0, (Object)$aggregateId.getId()).execute();
    }

    private static final Publisher load$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher load$lambda$2(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher load$lambda$3(R2dbcSnapshotRepository this$0, AggregateId $aggregateId, Result it) {
        return it.map(arg_0 -> R2dbcSnapshotRepository.load$lambda$3$1(arg_0 -> R2dbcSnapshotRepository.load$lambda$3$0(this$0, $aggregateId, arg_0), arg_0));
    }

    private static final Snapshot load$lambda$3$0(R2dbcSnapshotRepository this$0, AggregateId $aggregateId, Readable readable) {
        Intrinsics.checkNotNull((Object)readable);
        return this$0.mapSnapshot($aggregateId, readable);
    }

    private static final Snapshot load$lambda$3$1(Function1 $tmp0, Object p0) {
        return (Snapshot)$tmp0.invoke(p0);
    }

    private static final Publisher load$lambda$4(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher save$lambda$0(R2dbcSnapshotRepository this$0, Snapshot $snapshot, Connection it) {
        return it.createStatement(this$0.snapshotSchema.save($snapshot.getAggregateId())).bind(0, (Object)$snapshot.getAggregateId().getId()).bind(1, (Object)$snapshot.getAggregateId().getTenantId()).bind(2, (Object)$snapshot.getOwnerId()).bind(3, (Object)$snapshot.getVersion()).bind(4, (Object)$snapshot.getState().getClass().getName()).bind(5, (Object)JsonSerializerKt.toJsonString((Object)$snapshot.getState())).bind(6, (Object)$snapshot.getEventId()).bind(7, (Object)$snapshot.getFirstOperator()).bind(8, (Object)$snapshot.getOperator()).bind(9, (Object)$snapshot.getFirstEventTime()).bind(10, (Object)$snapshot.getEventTime()).bind(11, (Object)$snapshot.getSnapshotTime()).bind(12, (Object)$snapshot.getDeleted()).execute();
    }

    private static final Publisher save$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher save$lambda$2(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher save$lambda$3(Result it) {
        return it.getRowsUpdated();
    }

    private static final Publisher save$lambda$4(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher scanAggregateId$lambda$0(R2dbcSnapshotRepository this$0, DefaultAggregateId $aggregateId, String $afterId, int $limit, Connection it) {
        return it.createStatement(this$0.snapshotSchema.scan((AggregateId)$aggregateId)).bind(0, (Object)$afterId).bind(1, (Object)$limit).execute();
    }

    private static final Publisher scanAggregateId$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher scanAggregateId$lambda$2(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher scanAggregateId$lambda$3(NamedAggregate $namedAggregate, Result it) {
        return it.map(arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$3$1(arg_0 -> R2dbcSnapshotRepository.scanAggregateId$lambda$3$0($namedAggregate, arg_0), arg_0));
    }

    private static final DefaultAggregateId scanAggregateId$lambda$3$0(NamedAggregate $namedAggregate, Readable readable) {
        Object object = readable.get("aggregate_id", String.class);
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        String aggregateId = (String)object;
        Object object2 = readable.get("tenant_id", String.class);
        if (object2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        String tenantId = (String)object2;
        return DefaultAggregateIdKt.aggregateId((NamedAggregate)$namedAggregate, (String)aggregateId, (String)tenantId);
    }

    private static final DefaultAggregateId scanAggregateId$lambda$3$1(Function1 $tmp0, Object p0) {
        return (DefaultAggregateId)$tmp0.invoke(p0);
    }

    private static final Publisher scanAggregateId$lambda$4(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/r2dbc/R2dbcSnapshotRepository$Companion;", "", "<init>", "()V", "NAME", "", "wow-r2dbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

