/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.schema.WowModule;
import me.ahoo.wow.schema.WowOption;
import me.ahoo.wow.serialization.JsonSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e\"\u00020\f\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/schema/JsonSchemaGenerator;", "", "options", "", "Lme/ahoo/wow/schema/WowOption;", "<init>", "(Ljava/util/Set;)V", "schemaGenerator", "Lcom/github/victools/jsonschema/generator/SchemaGenerator;", "generate", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "mainTargetType", "Ljava/lang/reflect/Type;", "typeParameters", "", "(Ljava/lang/reflect/Type;[Ljava/lang/reflect/Type;)Lcom/fasterxml/jackson/databind/node/ObjectNode;", "wow-schema"})
public final class JsonSchemaGenerator {
    @NotNull
    private final Set<WowOption> options;
    @NotNull
    private final SchemaGenerator schemaGenerator;

    public JsonSchemaGenerator(@NotNull Set<? extends WowOption> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.options = options;
        JacksonOption[] jacksonOptionArray = new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED};
        Module jacksonModule = (Module)new JacksonModule(jacksonOptionArray);
        JakartaValidationModule jakartaModule = new JakartaValidationModule(new JakartaValidationOption[0]);
        Module openApiModule = (Module)new Swagger2Module();
        WowModule wowModule = new WowModule(this.options);
        SchemaGeneratorConfigBuilder schemaGeneratorConfigBuilder = new SchemaGeneratorConfigBuilder((ObjectMapper)JsonSerializer.INSTANCE, SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with(jacksonModule).with((Module)jakartaModule).with(openApiModule).with((Module)wowModule).with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]).with(Option.NONPUBLIC_NONSTATIC_FIELDS_WITHOUT_GETTERS, new Option[0]);
        this.schemaGenerator = new SchemaGenerator(schemaGeneratorConfigBuilder.build());
    }

    @NotNull
    public final ObjectNode generate(@NotNull Type mainTargetType, Type ... typeParameters) {
        Intrinsics.checkNotNullParameter((Object)mainTargetType, (String)"mainTargetType");
        Intrinsics.checkNotNullParameter((Object)typeParameters, (String)"typeParameters");
        ObjectNode objectNode = this.schemaGenerator.generateSchema(mainTargetType, Arrays.copyOf(typeParameters, typeParameters.length));
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"generateSchema(...)");
        return objectNode;
    }
}

