/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.LocalCommandBus;
import me.ahoo.wow.command.LocalFirstCommandBus;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@EnableConfigurationProperties(value={CommandProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\bH\u0017J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/CommandAutoConfiguration;", "", "commandProperties", "Lme/ahoo/wow/spring/boot/starter/command/CommandProperties;", "(Lme/ahoo/wow/spring/boot/starter/command/CommandProperties;)V", "getCommandProperties", "()Lme/ahoo/wow/spring/boot/starter/command/CommandProperties;", "inMemoryCommandBus", "Lme/ahoo/wow/command/LocalCommandBus;", "localCommandBus", "localFirstCommandBus", "Lme/ahoo/wow/command/LocalFirstCommandBus;", "distributedCommandBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "wow-spring-boot-starter"})
public class CommandAutoConfiguration {
    @NotNull
    private final CommandProperties commandProperties;

    public CommandAutoConfiguration(@NotNull CommandProperties commandProperties) {
        Intrinsics.checkNotNullParameter((Object)commandProperties, (String)"commandProperties");
        this.commandProperties = commandProperties;
    }

    @NotNull
    public CommandProperties getCommandProperties() {
        return this.commandProperties;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="in_memory")
    @NotNull
    public LocalCommandBus inMemoryCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalCommandBus.class})
    @ConditionalOnProperty(value={"wow.command.local-first.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public LocalCommandBus localCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={LocalCommandBus.class, DistributedCommandBus.class})
    @ConditionalOnProperty(value={"wow.command.local-first.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public LocalFirstCommandBus localFirstCommandBus(@NotNull LocalCommandBus localCommandBus, @NotNull DistributedCommandBus distributedCommandBus) {
        Intrinsics.checkNotNullParameter((Object)localCommandBus, (String)"localCommandBus");
        Intrinsics.checkNotNullParameter((Object)distributedCommandBus, (String)"distributedCommandBus");
        return new LocalFirstCommandBus(distributedCommandBus, this.getCommandProperties().getBus().getLocalFirst().getDoubleSend(), localCommandBus, null, 8, null);
    }
}

