/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.opentelemetry;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.opentelemetry.Tracing;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/spring/boot/starter/opentelemetry/TracingBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "Lorg/springframework/core/Ordered;", "()V", "getOrder", "", "postProcessAfterInitialization", "", "bean", "beanName", "", "Companion", "wow-spring-boot-starter"})
public final class TracingBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(TracingBeanPostProcessor.class);

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Object tracingBean = Tracing.INSTANCE.tracing(bean);
        if (tracingBean != bean && log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{beanName, bean.getClass().getName(), tracingBean.getClass().getName()};
            log.info("Tracing bean [{}] [{}] -> [{}]", objectArray);
        }
        return tracingBean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/spring/boot/starter/opentelemetry/TracingBeanPostProcessor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

