/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.event.DistributedDomainEventBus;
import me.ahoo.wow.redis.bus.RedisCommandBus;
import me.ahoo.wow.redis.bus.RedisDomainEventBus;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.redis.ConditionalOnRedisEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

@AutoConfiguration(before={CommandAutoConfiguration.class}, after={RedisReactiveAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnRedisEnabled
@ConditionalOnClass(value={RedisCommandBus.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/spring/boot/starter/redis/RedisMessageBusAutoConfiguration;", "", "()V", "redisCommandBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "redisDomainEventBus", "Lme/ahoo/wow/event/DistributedDomainEventBus;", "wow-spring-boot-starter"})
public class RedisMessageBusAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="redis")
    @NotNull
    public DistributedCommandBus redisCommandBus(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (DistributedCommandBus)new RedisCommandBus(redisTemplate, null, null, 6, null);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.event.bus.type"}, havingValue="redis")
    @NotNull
    public DistributedDomainEventBus redisDomainEventBus(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (DistributedDomainEventBus)new RedisDomainEventBus(redisTemplate, null, null, 6, null);
    }
}

