/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.mongo;

import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.infra.prepare.PrepareKeyFactory;
import me.ahoo.wow.mongo.EventStreamSchemaInitializer;
import me.ahoo.wow.mongo.MongoEventStore;
import me.ahoo.wow.mongo.MongoSnapshotRepository;
import me.ahoo.wow.mongo.SnapshotSchemaInitializer;
import me.ahoo.wow.mongo.prepare.MongoPrepareKeyFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.mongo.ConditionalOnMongoEnabled;
import me.ahoo.wow.spring.boot.starter.mongo.MongoProperties;
import me.ahoo.wow.spring.boot.starter.prepare.ConditionalOnPrepareEnabled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={MongoReactiveAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnMongoEnabled
@ConditionalOnClass(value={MongoEventStore.class})
@EnableConfigurationProperties(value={MongoProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\nH\u0017J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\nH\u0017J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/spring/boot/starter/mongo/MongoEventSourcingAutoConfiguration;", "", "mongoProperties", "Lme/ahoo/wow/spring/boot/starter/mongo/MongoProperties;", "(Lme/ahoo/wow/spring/boot/starter/mongo/MongoProperties;)V", "mongoEventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "mongoClient", "Lcom/mongodb/reactivestreams/client/MongoClient;", "dataMongoProperties", "Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;", "mongoPrepareKeyFactory", "Lme/ahoo/wow/infra/prepare/PrepareKeyFactory;", "mongoSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "wow-spring-boot-starter"})
public class MongoEventSourcingAutoConfiguration {
    @NotNull
    private final MongoProperties mongoProperties;

    public MongoEventSourcingAutoConfiguration(@NotNull MongoProperties mongoProperties) {
        Intrinsics.checkNotNullParameter((Object)mongoProperties, (String)"mongoProperties");
        this.mongoProperties = mongoProperties;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="mongo", matchIfMissing=true)
    @NotNull
    public EventStore mongoEventStore(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        String eventStoreDatabaseName;
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        String string = this.mongoProperties.getEventStreamDatabase();
        if (string == null) {
            org.springframework.boot.autoconfigure.mongo.MongoProperties mongoProperties = dataMongoProperties;
            string = mongoProperties != null ? mongoProperties.getMongoClientDatabase() : null;
        }
        if ((eventStoreDatabaseName = string) == null) {
            boolean $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoEventStore$22 = false;
            String $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoEventStore$22 = "wow.mongo.event-stream-database must not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoEventStore$22.toString());
        }
        MongoDatabase eventStoreDatabase = mongoClient.getDatabase(eventStoreDatabaseName);
        if (this.mongoProperties.getAutoInitSchema()) {
            Intrinsics.checkNotNullExpressionValue((Object)eventStoreDatabase, (String)"eventStoreDatabase");
            new EventStreamSchemaInitializer(eventStoreDatabase, false, 2, null).initAll();
        }
        Intrinsics.checkNotNullExpressionValue((Object)eventStoreDatabase, (String)"eventStoreDatabase");
        return (EventStore)new MongoEventStore(eventStoreDatabase);
    }

    @Bean
    @ConditionalOnSnapshotEnabled
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="mongo", matchIfMissing=true)
    @NotNull
    public SnapshotRepository mongoSnapshotRepository(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        String snapshotDatabaseName;
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        String string = this.mongoProperties.getSnapshotDatabase();
        if (string == null) {
            org.springframework.boot.autoconfigure.mongo.MongoProperties mongoProperties = dataMongoProperties;
            string = mongoProperties != null ? mongoProperties.getMongoClientDatabase() : null;
        }
        if ((snapshotDatabaseName = string) == null) {
            boolean $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoSnapshotRepository$22 = false;
            String $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoSnapshotRepository$22 = "wow.mongo.snapshot-database must not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoSnapshotRepository$22.toString());
        }
        MongoDatabase snapshotDatabase = mongoClient.getDatabase(snapshotDatabaseName);
        if (this.mongoProperties.getAutoInitSchema()) {
            Intrinsics.checkNotNullExpressionValue((Object)snapshotDatabase, (String)"snapshotDatabase");
            new SnapshotSchemaInitializer(snapshotDatabase).initAll();
        }
        Intrinsics.checkNotNullExpressionValue((Object)snapshotDatabase, (String)"snapshotDatabase");
        return (SnapshotRepository)new MongoSnapshotRepository(snapshotDatabase);
    }

    @Bean
    @ConditionalOnBean(value={MongoClient.class})
    @ConditionalOnProperty(value={"wow.prepare.storage"}, havingValue="mongo", matchIfMissing=true)
    @ConditionalOnPrepareEnabled
    @ConditionalOnMissingBean
    @NotNull
    public PrepareKeyFactory mongoPrepareKeyFactory(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        String prepareDatabaseName;
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        String string = this.mongoProperties.getPrepareDatabase();
        if (string == null) {
            org.springframework.boot.autoconfigure.mongo.MongoProperties mongoProperties = dataMongoProperties;
            string = mongoProperties != null ? mongoProperties.getMongoClientDatabase() : null;
        }
        if ((prepareDatabaseName = string) == null) {
            boolean $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoPrepareKeyFactory$22 = false;
            String $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoPrepareKeyFactory$22 = "wow.mongo.prepare-database must not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoPrepareKeyFactory$22.toString());
        }
        MongoDatabase prepareDatabase = mongoClient.getDatabase(prepareDatabaseName);
        Intrinsics.checkNotNullExpressionValue((Object)prepareDatabase, (String)"prepareDatabase");
        return (PrepareKeyFactory)new MongoPrepareKeyFactory(prepareDatabase);
    }
}

