/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.LocalCommandBus;
import me.ahoo.wow.command.LocalFirstCommandBus;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandProperties;
import me.ahoo.wow.spring.boot.starter.command.ConditionalOnCommandLocalFirstEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@EnableConfigurationProperties(value={CommandProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0004H\u0017J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/CommandAutoConfiguration;", "", "()V", "inMemoryCommandBus", "Lme/ahoo/wow/command/LocalCommandBus;", "localCommandBus", "localFirstCommandBus", "Lme/ahoo/wow/command/LocalFirstCommandBus;", "localBus", "distributedBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "wow-spring-boot-starter"})
public class CommandAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="in_memory")
    @NotNull
    public LocalCommandBus inMemoryCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalCommandBus.class})
    @ConditionalOnBean(value={DistributedCommandBus.class})
    @ConditionalOnCommandLocalFirstEnabled
    @NotNull
    public LocalCommandBus localCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={LocalCommandBus.class, DistributedCommandBus.class})
    @ConditionalOnCommandLocalFirstEnabled
    @NotNull
    public LocalFirstCommandBus localFirstCommandBus(@NotNull LocalCommandBus localBus, @NotNull DistributedCommandBus distributedBus) {
        Intrinsics.checkNotNullParameter((Object)localBus, (String)"localBus");
        Intrinsics.checkNotNullParameter((Object)distributedBus, (String)"distributedBus");
        return new LocalFirstCommandBus(distributedBus, localBus);
    }
}

