/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.elasticsearch;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.elasticsearch.DefaultSnapshotIndexNameConverter;
import me.ahoo.wow.elasticsearch.ElasticsearchSnapshotRepository;
import me.ahoo.wow.elasticsearch.SnapshotIndexNameConverter;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;

@AutoConfiguration
@ConditionalOnWowEnabled
@ConditionalOnSnapshotEnabled
@ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="elasticsearch")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/spring/boot/starter/elasticsearch/ElasticsearchSnapshotAutoConfiguration;", "", "()V", "snapshotIndexNameConverter", "Lme/ahoo/wow/elasticsearch/SnapshotIndexNameConverter;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/reactive/ReactiveElasticsearchClient;", "wow-spring-boot-starter"})
public class ElasticsearchSnapshotAutoConfiguration {
    @Bean
    @NotNull
    public SnapshotIndexNameConverter snapshotIndexNameConverter() {
        return (SnapshotIndexNameConverter)DefaultSnapshotIndexNameConverter.INSTANCE;
    }

    @Bean
    @NotNull
    public SnapshotRepository snapshotRepository(@NotNull ReactiveElasticsearchClient elasticsearchClient, @NotNull SnapshotIndexNameConverter snapshotIndexNameConverter) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        Intrinsics.checkNotNullParameter((Object)snapshotIndexNameConverter, (String)"snapshotIndexNameConverter");
        return (SnapshotRepository)new ElasticsearchSnapshotRepository(elasticsearchClient, snapshotIndexNameConverter, null, 4, null);
    }
}

