/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.eventsourcing.snapshot.DefaultSnapshotHandler;
import me.ahoo.wow.eventsourcing.snapshot.InMemorySnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotDispatcher;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotFunctionFilter;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotHandler;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotStrategy;
import me.ahoo.wow.eventsourcing.state.StateEventBus;
import me.ahoo.wow.eventsourcing.state.StateEventExchange;
import me.ahoo.wow.messaging.handler.Filter;
import me.ahoo.wow.messaging.handler.FilterChain;
import me.ahoo.wow.messaging.handler.FilterChainBuilder;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.SnapshotProperties;
import me.ahoo.wow.spring.command.SnapshotDispatcherLauncher;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@ConditionalOnSnapshotEnabled
@EnableConfigurationProperties(value={SnapshotProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0017J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0017J*\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0016\u0010\u0015\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00170\u0016H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0017J\u001c\u0010\f\u001a\u00020\r2\u0012\b\u0001\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0017\u00a8\u0006\u001c"}, d2={"Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotAutoConfiguration;", "", "()V", "inMemorySnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "simpleSnapshotStrategy", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotStrategy;", "snapshotRepository", "snapshotDispatcher", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotDispatcher;", "namedBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "snapshotHandler", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotHandler;", "stateEventBus", "Lme/ahoo/wow/eventsourcing/state/StateEventBus;", "snapshotDispatcherLauncher", "Lme/ahoo/wow/spring/command/SnapshotDispatcherLauncher;", "snapshotFilterChain", "Lme/ahoo/wow/messaging/handler/FilterChain;", "Lme/ahoo/wow/eventsourcing/state/StateEventExchange;", "filters", "", "Lme/ahoo/wow/messaging/handler/Filter;", "snapshotFunctionFilter", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotFunctionFilter;", "snapshotStrategy", "chain", "wow-spring-boot-starter"})
public class SnapshotAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="in_memory")
    @NotNull
    public SnapshotRepository inMemorySnapshotRepository() {
        return (SnapshotRepository)new InMemorySnapshotRepository();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SnapshotStrategy simpleSnapshotStrategy(@NotNull SnapshotRepository snapshotRepository) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        return (SnapshotStrategy)new SimpleSnapshotStrategy(snapshotRepository);
    }

    @Bean
    @NotNull
    public SnapshotFunctionFilter snapshotFunctionFilter(@NotNull SnapshotStrategy snapshotStrategy) {
        Intrinsics.checkNotNullParameter((Object)snapshotStrategy, (String)"snapshotStrategy");
        return new SnapshotFunctionFilter(snapshotStrategy);
    }

    @Bean
    @NotNull
    public FilterChain<StateEventExchange<?>> snapshotFilterChain(@NotNull List<? extends Filter<StateEventExchange<?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(SnapshotDispatcher.class)).build();
    }

    @Bean
    @NotNull
    public SnapshotHandler snapshotHandler(@Qualifier(value="snapshotFilterChain") @NotNull FilterChain<StateEventExchange<?>> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        return (SnapshotHandler)new DefaultSnapshotHandler(chain, null, 2, null);
    }

    @Bean
    @NotNull
    public SnapshotDispatcher snapshotDispatcher(@NotNull NamedBoundedContext namedBoundedContext, @NotNull SnapshotHandler snapshotHandler, @NotNull StateEventBus stateEventBus) {
        Intrinsics.checkNotNullParameter((Object)namedBoundedContext, (String)"namedBoundedContext");
        Intrinsics.checkNotNullParameter((Object)snapshotHandler, (String)"snapshotHandler");
        Intrinsics.checkNotNullParameter((Object)stateEventBus, (String)"stateEventBus");
        return new SnapshotDispatcher(namedBoundedContext.getContextName() + '.' + Reflection.getOrCreateKotlinClass(SnapshotDispatcher.class).getSimpleName(), null, snapshotHandler, stateEventBus, 0, null, 50, null);
    }

    @Bean
    @NotNull
    public SnapshotDispatcherLauncher snapshotDispatcherLauncher(@NotNull SnapshotDispatcher snapshotDispatcher) {
        Intrinsics.checkNotNullParameter((Object)snapshotDispatcher, (String)"snapshotDispatcher");
        return new SnapshotDispatcherLauncher(snapshotDispatcher);
    }
}

