/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.webflux;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.event.compensation.DomainEventCompensator;
import me.ahoo.wow.event.compensation.StateEventCompensator;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.webflux.ConditionalOnWebfluxEnabled;
import me.ahoo.wow.spring.boot.starter.webflux.WebFluxProperties;
import me.ahoo.wow.webflux.exception.DefaultExceptionHandler;
import me.ahoo.wow.webflux.exception.ExceptionHandler;
import me.ahoo.wow.webflux.route.AggregateRouterFunctionAutoRegistrar;
import me.ahoo.wow.webflux.wait.CommandWaitHandlerFunction;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerResponse;

@AutoConfiguration(after={CommandAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnWebfluxEnabled
@EnableConfigurationProperties(value={WebFluxProperties.class})
@ConditionalOnClass(name={"org.springframework.web.server.WebFilter", "me.ahoo.wow.webflux.route.CommandHandlerFunction"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0017\u00a8\u0006\u001b"}, d2={"Lme/ahoo/wow/spring/boot/starter/webflux/WebFluxAutoConfiguration;", "", "()V", "commandRouterFunction", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "boundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "domainEventCompensator", "Lme/ahoo/wow/event/compensation/DomainEventCompensator;", "stateEventCompensator", "Lme/ahoo/wow/event/compensation/StateEventCompensator;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/ExceptionHandler;", "commandWaitRouterFunction", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "wow-spring-boot-starter"})
public class WebFluxAutoConfiguration {
    @Bean
    @NotNull
    public RouterFunction<ServerResponse> commandWaitRouterFunction(@NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        return new CommandWaitHandlerFunction(waitStrategyRegistrar).getRouterFunction();
    }

    @Bean
    @NotNull
    public RouterFunction<ServerResponse> commandRouterFunction(@NotNull NamedBoundedContext boundedContext, @NotNull CommandGateway commandGateway, @NotNull StateAggregateRepository stateAggregateRepository, @NotNull SnapshotRepository snapshotRepository, @NotNull StateAggregateFactory stateAggregateFactory, @NotNull DomainEventCompensator domainEventCompensator, @NotNull StateEventCompensator stateEventCompensator, @NotNull EventStore eventStore, @NotNull ExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)boundedContext, (String)"boundedContext");
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"stateAggregateRepository");
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)domainEventCompensator, (String)"domainEventCompensator");
        Intrinsics.checkNotNullParameter((Object)stateEventCompensator, (String)"stateEventCompensator");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        return new AggregateRouterFunctionAutoRegistrar(boundedContext, commandGateway, stateAggregateRepository, stateAggregateFactory, snapshotRepository, eventStore, domainEventCompensator, stateEventCompensator, exceptionHandler).getRouterFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ExceptionHandler exceptionHandler() {
        return (ExceptionHandler)DefaultExceptionHandler.INSTANCE;
    }
}

