/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.kafka;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.kafka.KafkaCommandBus;
import me.ahoo.wow.kafka.KafkaDomainEventBus;
import me.ahoo.wow.kafka.NoOpReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizer;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.kafka.ConditionalOnKafkaEnabled;
import me.ahoo.wow.spring.boot.starter.kafka.KafkaProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import reactor.kafka.sender.KafkaSender;

@AutoConfiguration(before={CommandAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnKafkaEnabled
@ConditionalOnClass(value={KafkaCommandBus.class})
@EnableConfigurationProperties(value={KafkaProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017J$\u0010\f\u001a\u00020\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/spring/boot/starter/kafka/KafkaAutoConfiguration;", "", "kafkaProperties", "Lme/ahoo/wow/spring/boot/starter/kafka/KafkaProperties;", "(Lme/ahoo/wow/spring/boot/starter/kafka/KafkaProperties;)V", "kafkaCommandBus", "Lme/ahoo/wow/command/CommandBus;", "kafkaSender", "Lreactor/kafka/sender/KafkaSender;", "", "receiverOptionsCustomizer", "Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;", "kafkaDomainEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "wow-spring-boot-starter"})
public class KafkaAutoConfiguration {
    @NotNull
    private final KafkaProperties kafkaProperties;

    public KafkaAutoConfiguration(@NotNull KafkaProperties kafkaProperties) {
        Intrinsics.checkNotNullParameter((Object)kafkaProperties, (String)"kafkaProperties");
        this.kafkaProperties = kafkaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ReceiverOptionsCustomizer receiverOptionsCustomizer() {
        return (ReceiverOptionsCustomizer)NoOpReceiverOptionsCustomizer.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KafkaSender<String, String> kafkaSender() {
        KafkaSender kafkaSender = KafkaSender.create(this.kafkaProperties.buildSenderOptions());
        Intrinsics.checkNotNullExpressionValue((Object)kafkaSender, (String)"create(kafkaProperties.buildSenderOptions())");
        return kafkaSender;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="kafka", matchIfMissing=true)
    @NotNull
    public CommandBus kafkaCommandBus(@NotNull KafkaSender<String, String> kafkaSender, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter(kafkaSender, (String)"kafkaSender");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        return (CommandBus)new KafkaCommandBus(kafkaSender, this.kafkaProperties.buildReceiverOptions(), this.kafkaProperties.getTopicPrefix(), receiverOptionsCustomizer);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.event.bus.type"}, havingValue="kafka", matchIfMissing=true)
    @NotNull
    public DomainEventBus kafkaDomainEventBus(@NotNull KafkaSender<String, String> kafkaSender, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter(kafkaSender, (String)"kafkaSender");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        return (DomainEventBus)new KafkaDomainEventBus(kafkaSender, this.kafkaProperties.buildReceiverOptions(), this.kafkaProperties.getTopicPrefix(), receiverOptionsCustomizer);
    }
}

