/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.opentelemetry;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.LocalFirstCommandBus;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.infra.Decorator;
import me.ahoo.wow.messaging.DistributedMessageBus;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.opentelemetry.messaging.Tracing;
import me.ahoo.wow.opentelemetry.messaging.TracingMessageBus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/spring/boot/starter/opentelemetry/TracingBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "Lorg/springframework/core/Ordered;", "localFirstEnabled", "", "(Z)V", "getOrder", "", "postProcessAfterInitialization", "", "bean", "beanName", "", "Companion", "wow-spring-boot-starter"})
public final class TracingBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean localFirstEnabled;
    private static final Logger log = LoggerFactory.getLogger(TracingBeanPostProcessor.class);

    public TracingBeanPostProcessor(boolean localFirstEnabled) {
        this.localFirstEnabled = localFirstEnabled;
    }

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        CommandBus tracingBean;
        CommandBus commandBus;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        if (bean instanceof TracingMessageBus) {
            return bean;
        }
        CommandBus commandBus2 = bean;
        if (commandBus2 instanceof CommandGateway) {
            commandBus = bean;
        } else if (commandBus2 instanceof DomainEventBus) {
            commandBus = Tracing.INSTANCE.tracing((DomainEventBus)bean);
        } else if (commandBus2 instanceof CommandBus) {
            CommandBus tracingCommandBus = Tracing.INSTANCE.tracing(bean);
            commandBus = this.localFirstEnabled && Decorator.Companion.getDelegate((Object)bean) instanceof DistributedMessageBus ? (CommandBus)new LocalFirstCommandBus(Metrics.INSTANCE.metrizable(tracingCommandBus), Metrics.INSTANCE.metrizable(Tracing.INSTANCE.tracing((CommandBus)new InMemoryCommandBus(null, 1, null))), null, 4, null) : tracingCommandBus;
        } else {
            commandBus = tracingBean = bean;
        }
        if (tracingBean != bean && log.isInfoEnabled()) {
            commandBus2 = new CommandBus[]{beanName, bean.getClass().getName(), tracingBean.getClass().getName()};
            log.info("Tracing bean [{}] [{}] -> [{}]", (Object[])commandBus2);
        }
        return tracingBean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/spring/boot/starter/opentelemetry/TracingBeanPostProcessor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

